/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit;

import org.kie.api.runtime.rule.FactHandle;

public interface DataSource<T>
extends Iterable<T> {
    public FactHandle insert(T var1);

    public void update(FactHandle var1, T var2, String ... var3);

    public void delete(FactHandle var1);

    public void delete(Object var1);

    public static <T> DataSource<T> create(T ... items) {
        try {
            DataSource<T> dataSource = DataSourceFactory.newInstance();
            for (T item : items) {
                dataSource.insert(item);
            }
            return dataSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instance KieServices", e);
        }
    }

    public static class DataSourceFactory {
        public static <T> DataSource<T> newInstance() {
            try {
                return (DataSource)LazyHolder.DATA_SOURCE_DEFAULT_CLASS.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static class LazyHolder {
            private static Class<?> DATA_SOURCE_DEFAULT_CLASS;

            private LazyHolder() {
            }

            static {
                try {
                    DATA_SOURCE_DEFAULT_CLASS = Class.forName("org.drools.ruleunit.datasources.CursoredDataSource");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

