/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.event.AbstractEventSupport;
import org.drools.core.event.MessageEventImpl;
import org.drools.core.event.ProcessAsyncNodeScheduledEventImpl;
import org.drools.core.event.ProcessCompletedEventImpl;
import org.drools.core.event.ProcessNodeLeftEventImpl;
import org.drools.core.event.ProcessNodeTriggeredEventImpl;
import org.drools.core.event.ProcessStartedEventImpl;
import org.drools.core.event.ProcessVariableChangedEventImpl;
import org.drools.core.event.SLAViolatedEventImpl;
import org.drools.core.event.SignalEventImpl;
import org.drools.core.event.rule.impl.ProcessDataChangedEventImpl;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessEventSupport
extends AbstractEventSupport<ProcessEventListener> {
    public void fireBeforeProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeProcessStarted(e));
        }
    }

    public void fireAfterProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterProcessStarted(e));
        }
    }

    public void fireBeforeProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeProcessCompleted(e));
        }
    }

    public void fireAfterProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterProcessCompleted(e));
        }
    }

    public void fireOnAsyncNodeScheduledEvent(NodeInstance nodeInstance, InternalKnowledgeRuntime kruntime, Map<String, Object> data) {
        if (this.hasListeners()) {
            ProcessAsyncNodeScheduledEventImpl event = new ProcessAsyncNodeScheduledEventImpl(nodeInstance, kruntime, data);
            this.notifyAllListeners(event, (l, e) -> l.onAsyncNodeScheduledEvent(e));
        }
    }

    public void fireBeforeNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeNodeTriggered(e));
        }
    }

    public void fireAfterNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterNodeTriggered(e));
        }
    }

    public void fireBeforeNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeNodeLeft(e));
        }
    }

    public void fireAfterNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterNodeLeft(e));
        }
    }

    public void fireBeforeVariableChanged(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(id, instanceId, oldValue, newValue, tags, processInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeVariableChanged(e));
        }
    }

    public void fireAfterVariableChanged(String name, String id, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(name, id, oldValue, newValue, tags, processInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterVariableChanged(e));
        }
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeSLAViolated(e));
        }
    }

    public void fireAfterSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterSLAViolated(e));
        }
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeSLAViolated(e));
        }
    }

    public void fireAfterSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterSLAViolated(e));
        }
    }

    public void fireOnSignal(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime, String signalName, Object signalObject) {
        if (this.hasListeners()) {
            SignalEventImpl event = new SignalEventImpl(instance, kruntime, nodeInstance, signalName, signalObject);
            this.notifyAllListeners(event, ProcessEventListener::onSignal);
        }
    }

    public void fireOnMessage(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime, String messageName, Object messageObject) {
        if (this.hasListeners()) {
            MessageEventImpl event = new MessageEventImpl(instance, kruntime, nodeInstance, messageName, messageObject);
            this.notifyAllListeners(event, ProcessEventListener::onMessage);
        }
    }

    public void fireAfterProcessDataChanged(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessDataChangedEventImpl event = new ProcessDataChangedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.onProcessDataChangedEvent(e));
        }
    }

    public void reset() {
        this.clear();
    }
}

