/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import org.drools.core.marshalling.impl.ActivationKey;
import org.drools.core.marshalling.impl.TupleKey;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Tuple;

public class MarshallingHelper {
    public static ActivationKey createActivationKey(String pkgName, String ruleName, Tuple leftTuple) {
        return MarshallingHelper.createActivationKey(pkgName, ruleName, MarshallingHelper.toArrayOfObject(MarshallingHelper.createTupleArray(leftTuple)));
    }

    public static ActivationKey createActivationKey(String pkgName, String ruleName, Object[] tuple) {
        return new ActivationKey(pkgName, ruleName, tuple);
    }

    public static TupleKey createTupleKey(Tuple leftTuple) {
        return new TupleKey(MarshallingHelper.createTupleArray(leftTuple));
    }

    protected static Object[] toArrayOfObject(long[] longs) {
        Object[] objects = new Object[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            objects[i] = longs[i];
        }
        return objects;
    }

    protected static long[] createTupleArray(Tuple tuple) {
        if (tuple != null) {
            LeftTuple leftTuple = (LeftTuple)tuple;
            long[] tupleArray = new long[leftTuple.getTupleSink().getLeftTupleSource().getObjectCount()];
            int i = tupleArray.length - 1;
            for (Tuple entry = leftTuple.skipEmptyHandles(); entry != null; entry = entry.getParent()) {
                tupleArray[i--] = entry.getFactHandle().getId();
            }
            return tupleArray;
        }
        return new long[0];
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static final byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    public static final long byteArrayToLong(byte[] b) {
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + ((long)b[7] & 0xFFL);
    }

    public static boolean hasNodeMemory(TerminalNode terminalNode) {
        return MarshallingHelper.hasNodeMemory(terminalNode.getLeftTupleSource());
    }

    private static boolean hasNodeMemory(LeftTupleSource leftTupleSource) {
        if (leftTupleSource == null) {
            return false;
        }
        return NodeTypeEnums.hasNodeMemory(leftTupleSource) ? true : MarshallingHelper.hasNodeMemory(leftTupleSource.getLeftTupleSource());
    }
}

