/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class BoundaryEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = -4958054074031174180L;

    @Override
    public void signalEvent(String type, Object event) {
        BoundaryEventNode boundaryNode = this.getEventNode();
        String attachedTo = boundaryNode.getAttachedToNodeId();
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        if (type != null && type.startsWith("Compensation")) {
            if (!this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event) && this.isAttachedToNodeCompleted(attachedTo)) {
                super.signalEvent(type, event);
            } else {
                this.cancel();
            }
        } else if (this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event)) {
            super.signalEvent(type, event);
        } else {
            this.cancel();
        }
    }

    @Override
    public BoundaryEventNode getEventNode() {
        return (BoundaryEventNode)super.getEventNode();
    }

    @Override
    public void triggerCompleted(String type, Object event) {
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        String attachedTo = this.getEventNode().getAttachedToNodeId();
        Collection<NodeInstance> attachedNodeInstances = this.getAttachedToNodeActive(nodeInstances, attachedTo, type, event);
        List<DataAssociation> dataAssociation = this.getEventNode().getOutAssociations();
        if (!dataAssociation.isEmpty()) {
            if (attachedNodeInstances.isEmpty()) {
                this.mapOutputData(dataAssociation, null, type, event);
            } else {
                for (NodeInstance nodeInstance : attachedNodeInstances) {
                    this.mapOutputData(dataAssociation, nodeInstance, type, event);
                }
            }
        }
        this.triggerEvent("onBoundary");
        super.triggerCompleted();
    }

    private boolean isAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        return !this.getAttachedToNodeActive(nodeInstances, attachedTo, type, event).isEmpty();
    }

    private void mapOutputData(List<DataAssociation> dataAssociation, NodeInstance nodeInstance, String type, Object event) {
        HashMap<String, Object> outputData = new HashMap<String, Object>();
        outputData.put(dataAssociation.get(0).getSources().get(0), event);
        outputData.put("nodeInstance", nodeInstance);
        outputData.put("signal", type);
        outputData.put("event", event);
        if (nodeInstance instanceof WorkItemNodeInstance) {
            outputData.put("workItem", ((WorkItemNodeInstance)nodeInstance).getWorkItem());
        }
        this.mapOutputSetVariables(this, this.getEventNode().getOutAssociations(), outputData);
    }

    private Collection<NodeInstance> getAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        HashSet<NodeInstance> result = new HashSet<NodeInstance>();
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                boolean isActivating = ((WorkflowProcessInstanceImpl)nInstance.getProcessInstance()).getActivatingNodeIds().contains(nodeUniqueId);
                if (attachedTo.equals(nodeUniqueId) && !isActivating) {
                    if (type.startsWith("Timer-")) {
                        if (!Long.valueOf(nInstance.getId()).equals(event)) continue;
                        result.add(nInstance);
                        continue;
                    }
                    result.add(nInstance);
                    continue;
                }
                if (!(nInstance instanceof CompositeNodeInstance)) continue;
                result.addAll(this.getAttachedToNodeActive(((CompositeNodeInstance)nInstance).getNodeInstances(), attachedTo, type, event));
            }
        }
        return result;
    }

    private boolean isAttachedToNodeCompleted(String attachedTo) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        return processInstance.getCompletedNodeIds().contains(attachedTo);
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
    }
}

