/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.Transformable;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPersistenceContext
implements PersistenceContext {
    protected static Logger logger = LoggerFactory.getLogger(JpaPersistenceContext.class);
    private EntityManager em;
    protected final boolean isJTA;
    protected final boolean pessimisticLocking;
    protected final TransactionManager txm;
    protected LockModeType lockMode;

    public JpaPersistenceContext(EntityManager em, TransactionManager txm) {
        this(em, true, false, null, txm);
    }

    public JpaPersistenceContext(EntityManager em, boolean isJTA, TransactionManager txm) {
        this(em, isJTA, false, null, txm);
    }

    public JpaPersistenceContext(EntityManager em, boolean isJTA, boolean locking, String lockingMode, TransactionManager txm) {
        this.em = em;
        this.isJTA = isJTA;
        this.pessimisticLocking = locking;
        this.txm = txm;
        this.lockMode = LockModeType.valueOf((String)(lockingMode == null ? LockModeType.PESSIMISTIC_FORCE_INCREMENT.name() : lockingMode));
    }

    public PersistentSession persist(PersistentSession entity) {
        this.em.persist((Object)entity);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)entity);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (PersistentSession)this.em.find(SessionInfo.class, (Object)entity.getId(), this.lockMode);
        }
        return entity;
    }

    public PersistentSession findSession(Long id) {
        logger.trace("Reading session info {}", (Object)id);
        SessionInfo sessionInfo = null;
        if (this.pessimisticLocking) {
            sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)id, this.lockMode);
            TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)sessionInfo);
            return sessionInfo;
        }
        sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)id);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)sessionInfo);
        return sessionInfo;
    }

    public void remove(PersistentSession session) {
        if (!this.em.contains((Object)session)) {
            SessionInfo s = (SessionInfo)this.em.getReference(SessionInfo.class, (Object)session.getId());
            this.em.remove((Object)s);
        } else {
            this.em.remove((Object)session);
        }
        TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)session);
        this.em.flush();
    }

    public void lock(PersistentSession session) {
        this.em.lock((Object)session, this.lockMode);
    }

    public boolean isOpen() {
        return this.em.isOpen();
    }

    public void joinTransaction() {
        if (this.isJTA) {
            this.em.joinTransaction();
        }
    }

    public void close() {
        this.em.close();
    }

    public PersistentWorkItem persist(PersistentWorkItem workItem) {
        this.em.persist((Object)workItem);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)workItem);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (PersistentWorkItem)this.em.find(WorkItemInfo.class, (Object)workItem.getId(), this.lockMode);
        }
        return workItem;
    }

    public PersistentWorkItem findWorkItem(Long id) {
        WorkItemInfo workItemInfo = null;
        if (this.pessimisticLocking) {
            workItemInfo = (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)id, this.lockMode);
            TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)workItemInfo);
            return workItemInfo;
        }
        workItemInfo = (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)id);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)workItemInfo);
        return workItemInfo;
    }

    public void remove(PersistentWorkItem workItem) {
        this.em.remove((Object)workItem);
        TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)workItem);
    }

    public PersistentWorkItem merge(PersistentWorkItem workItem) {
        if (this.pessimisticLocking) {
            if (this.em.contains((Object)workItem)) {
                this.em.lock((Object)workItem, this.lockMode);
            } else if (workItem.getId() != null) {
                WorkItemInfo dbWorkItemInfo = (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)workItem.getId(), this.lockMode);
                for (Field field : WorkItemInfo.class.getDeclaredFields()) {
                    boolean access = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        field.set(dbWorkItemInfo, field.get(workItem));
                    }
                    catch (Exception e) {
                        logger.error("Unable to set field " + field.getName() + " of unmerged WorkItemInfo instance!", (Throwable)e);
                    }
                    field.setAccessible(access);
                }
            }
        }
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)workItem);
        return (PersistentWorkItem)this.em.merge((Object)workItem);
    }

    public void lock(PersistentWorkItem workItem) {
        this.em.lock((Object)workItem, this.lockMode);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }
}

