/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.model;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.persistence.api.integration.InstanceView;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class TaskInstanceView
implements InstanceView<Task> {
    private static final long serialVersionUID = 8214656362310328071L;
    private String compositeId;
    private Long id;
    private Integer priority;
    private String name;
    private String subject;
    private String description;
    private String taskType;
    private String formName;
    private String status;
    private String actualOwner;
    private String createdBy;
    private Date createdOn;
    private Date activationTime;
    private Date expirationDate;
    private Boolean skipable;
    private Long workItemId;
    private Long processInstanceId;
    private Long parentId;
    private String processId;
    private String containerId;
    private List<String> potentialOwners;
    private List<String> excludedOwners;
    private List<String> businessAdmins;
    private Map<String, Object> inputData;
    private Map<String, Object> outputData;
    private transient Task source;

    public TaskInstanceView() {
    }

    public TaskInstanceView(Task source) {
        this.source = source;
        this.copyFromSource();
    }

    @Override
    public String getCompositeId() {
        return this.compositeId;
    }

    public void setCompositeId(String compositeId) {
        this.compositeId = compositeId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    public void setActualOwner(String actualOwner) {
        this.actualOwner = actualOwner;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean getSkipable() {
        return this.skipable;
    }

    public void setSkipable(Boolean skipable) {
        this.skipable = skipable;
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(Long workItemId) {
        this.workItemId = workItemId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public List<String> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<String> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public List<String> getExcludedOwners() {
        return this.excludedOwners;
    }

    public void setExcludedOwners(List<String> excludedOwners) {
        this.excludedOwners = excludedOwners;
    }

    public List<String> getBusinessAdmins() {
        return this.businessAdmins;
    }

    public void setBusinessAdmins(List<String> businessAdmins) {
        this.businessAdmins = businessAdmins;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public String toString() {
        return "TaskInstance{id=" + this.id + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", status='" + this.status + '\'' + ", actualOwner='" + this.actualOwner + '\'' + ", processInstanceId=" + this.processInstanceId + ", processId='" + this.processId + '\'' + ", containerId='" + this.containerId + '\'' + '}';
    }

    @Override
    public Task getSource() {
        return this.source;
    }

    @Override
    public void copyFromSource() {
        if (this.id != null) {
            return;
        }
        this.compositeId = System.getProperty("org.kie.server.id", "") + "_" + this.source.getId();
        this.activationTime = this.source.getTaskData().getActivationTime();
        this.actualOwner = this.safeOrgEntity((OrganizationalEntity)this.source.getTaskData().getActualOwner());
        this.businessAdmins = this.source.getPeopleAssignments().getBusinessAdministrators().stream().map(entity -> this.safeOrgEntity((OrganizationalEntity)entity)).collect(Collectors.toList());
        this.containerId = this.source.getTaskData().getDeploymentId();
        this.createdBy = this.safeOrgEntity((OrganizationalEntity)this.source.getTaskData().getCreatedBy());
        this.createdOn = this.source.getTaskData().getCreatedOn();
        this.description = this.source.getDescription();
        this.excludedOwners = ((InternalPeopleAssignments)this.source.getPeopleAssignments()).getExcludedOwners().stream().map(entity -> this.safeOrgEntity((OrganizationalEntity)entity)).collect(Collectors.toList());
        this.expirationDate = this.source.getTaskData().getExpirationTime();
        this.formName = this.source.getFormName();
        this.id = this.source.getId();
        this.inputData = this.source.getTaskData().getTaskInputVariables();
        this.name = this.source.getName();
        this.outputData = this.source.getTaskData().getTaskOutputVariables();
        this.parentId = this.source.getTaskData().getParentId();
        this.potentialOwners = this.source.getPeopleAssignments().getPotentialOwners().stream().map(entity -> this.safeOrgEntity((OrganizationalEntity)entity)).collect(Collectors.toList());
        this.priority = this.source.getPriority();
        this.processId = this.source.getTaskData().getProcessId();
        this.processInstanceId = this.source.getTaskData().getProcessInstanceId();
        this.skipable = this.source.getTaskData().isSkipable();
        this.status = this.source.getTaskData().getStatus().name();
        this.subject = this.source.getSubject();
        this.taskType = this.source.getTaskType();
        this.workItemId = this.source.getTaskData().getWorkItemId();
    }

    protected String safeOrgEntity(OrganizationalEntity entity) {
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskInstanceView other = (TaskInstanceView)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

