/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.DefaultTimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.kie.api.time.SessionClock;

public class JDKTimerService
implements TimerService,
SessionClock,
InternalSchedulerService {
    private AtomicLong idCounter = new AtomicLong();
    protected ScheduledThreadPoolExecutor scheduler;
    protected TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.instance;

    public JDKTimerService() {
        this(1);
    }

    public JDKTimerService(int size) {
        this.scheduler = new ScheduledThreadPoolExecutor(size);
    }

    @Override
    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    public void setCounter(long counter) {
        this.idCounter = new AtomicLong(counter);
    }

    @Override
    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            JDKJobHandle jobHandle = new JDKJobHandle(this.idCounter.getAndIncrement());
            TimerJobInstance jobInstance = this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, jobHandle, this);
            jobHandle.setTimerJobInstance(jobInstance);
            this.internalSchedule(jobInstance);
            return jobHandle;
        }
        return null;
    }

    @Override
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        Date date = timerJobInstance.getTrigger().hasNextFireTime();
        Callable item = (Callable)((Object)timerJobInstance);
        JDKJobHandle jobHandle = (JDKJobHandle)timerJobInstance.getJobHandle();
        long then = date.getTime();
        long now = System.currentTimeMillis();
        ScheduledFuture<Void> future = null;
        future = then >= now ? this.scheduler.schedule(item, then - now, TimeUnit.MILLISECONDS) : this.scheduler.schedule(item, 0L, TimeUnit.MILLISECONDS);
        jobHandle.setFuture(future);
        this.jobFactoryManager.addTimerJobInstance(timerJobInstance);
    }

    @Override
    public boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        JDKJobHandle jdkJobHandle = (JDKJobHandle)jobHandle;
        this.jobFactoryManager.removeTimerJobInstance(jdkJobHandle.getTimerJobInstance());
        return this.scheduler.remove((Runnable)((Object)jdkJobHandle.getFuture()));
    }

    @Override
    public long getTimeToNextJob() {
        return 0L;
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        return this.jobFactoryManager.getTimerJobInstances();
    }

    public static class JDKJobHandle
    extends DefaultJobHandle
    implements JobHandle {
        private static final long serialVersionUID = 510L;
        private ScheduledFuture<Void> future;

        public JDKJobHandle(long id) {
            super(id);
        }

        public ScheduledFuture<Void> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<Void> future) {
            this.future = future;
        }
    }
}

