/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupBuilder;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.AbstractDataSetLookupBuilder;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.query.AggregateColumnFilter;
import org.jbpm.kie.services.impl.query.CoreFunctionQueryParamBuilder;
import org.jbpm.kie.services.impl.query.ExtraColumnFilter;
import org.jbpm.kie.services.impl.query.GroupColumnFilter;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.persistence.PersistDataSetListener;
import org.jbpm.kie.services.impl.query.persistence.QueryDefinitionEntity;
import org.jbpm.kie.services.impl.query.preprocessor.BusinessAdminPreprocessor;
import org.jbpm.kie.services.impl.query.preprocessor.BusinessAdminTasksPreprocessor;
import org.jbpm.kie.services.impl.query.preprocessor.DeploymentIdsPreprocessor;
import org.jbpm.kie.services.impl.query.preprocessor.PotOwnerTasksPreprocessor;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.query.QueryAlreadyRegisteredException;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryParamBuilder;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.query.AdvancedQueryContext;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImpl
implements QueryService,
DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(QueryServiceImpl.class);
    private DataSetDefRegistry dataSetDefRegistry;
    private DataSetManager dataSetManager;
    private DataSetProviderRegistry providerRegistry;
    private IdentityProvider identityProvider;
    private TransactionalCommandService commandService;
    private DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();

    public QueryServiceImpl() {
        ServiceRegistry.get().register(QueryService.class.getSimpleName(), (Object)this);
    }

    public void setDeploymentRolesManager(DeploymentRolesManager deploymentRolesManager) {
        this.deploymentRolesManager = deploymentRolesManager;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setDataSetDefRegistry(DataSetDefRegistry dataSetDefRegistry) {
        this.dataSetDefRegistry = dataSetDefRegistry;
    }

    public void setProviderRegistry(DataSetProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    public void setDataSetManager(DataSetManager dataSetManager) {
        this.dataSetManager = dataSetManager;
    }

    public void init() {
        if (this.dataSetDefRegistry == null && this.dataSetManager == null && this.providerRegistry == null) {
            this.dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
            this.dataSetManager = DataSetCore.get().getDataSetManager();
            this.providerRegistry = DataSetCore.get().getDataSetProviderRegistry();
            this.providerRegistry.registerDataProvider((DataSetProvider)SQLDataSetProvider.get());
            this.dataSetDefRegistry.addListener((DataSetDefRegistryListener)new PersistDataSetListener(this.commandService));
        }
        if (this.commandService != null) {
            List queries = (List)this.commandService.execute((Command)new QueryNameCommand("getQueryDefinitions"));
            for (QueryDefinitionEntity entity : queries) {
                QueryDefinition definition = entity.toQueryDefinition();
                try {
                    this.registerQuery(definition);
                }
                catch (QueryAlreadyRegisteredException e) {
                    logger.debug("Query {} already registered, skipping...", (Object)definition.getName());
                }
            }
        }
    }

    public void registerQuery(QueryDefinition queryDefinition) throws QueryAlreadyRegisteredException {
        if (this.dataSetDefRegistry.getDataSetDef(queryDefinition.getName()) != null) {
            throw new QueryAlreadyRegisteredException("Query" + queryDefinition.getName() + " is already registered");
        }
        this.replaceQuery(queryDefinition);
    }

    public void replaceQuery(QueryDefinition queryDefinition) {
        logger.debug("About to register {} query...", (Object)queryDefinition);
        if (queryDefinition instanceof SqlQueryDefinition) {
            SqlQueryDefinition sqlQueryDefinition = (SqlQueryDefinition)queryDefinition;
            SQLDataSetDefBuilderImpl builder = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid(sqlQueryDefinition.getName())).name(sqlQueryDefinition.getName() + "::" + sqlQueryDefinition.getTarget().toString())).dataSource(sqlQueryDefinition.getSource()).dbSQL(sqlQueryDefinition.getExpression(), true);
            DataSetDef sqlDef = builder.buildDef();
            try {
                this.dataSetDefRegistry.registerDataSetDef(sqlDef);
                DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata(sqlDef.getUUID());
                if (queryDefinition.getTarget().equals((Object)QueryDefinition.Target.BA_TASK)) {
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new BusinessAdminTasksPreprocessor(this.identityProvider, metadata));
                } else if (queryDefinition.getTarget().equals((Object)QueryDefinition.Target.PO_TASK)) {
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new PotOwnerTasksPreprocessor(this.identityProvider, metadata));
                } else if (queryDefinition.getTarget().equals((Object)QueryDefinition.Target.FILTERED_PROCESS)) {
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new DeploymentIdsPreprocessor(this.deploymentRolesManager, this.identityProvider, "EXTERNALID"));
                } else if (queryDefinition.getTarget().equals((Object)QueryDefinition.Target.FILTERED_BA_TASK)) {
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new BusinessAdminPreprocessor(this.identityProvider, metadata));
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new DeploymentIdsPreprocessor(this.deploymentRolesManager, this.identityProvider, "DEPLOYMENTID"));
                } else if (queryDefinition.getTarget().equals((Object)QueryDefinition.Target.FILTERED_PO_TASK)) {
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new PotOwnerTasksPreprocessor(this.identityProvider, metadata));
                    this.dataSetDefRegistry.registerPreprocessor(sqlDef.getUUID(), (DataSetPreprocessor)new DeploymentIdsPreprocessor(this.deploymentRolesManager, this.identityProvider, "DEPLOYMENTID"));
                }
                for (String columnId : metadata.getColumnIds()) {
                    logger.debug("Column {} is of type {}", (Object)columnId, (Object)metadata.getColumnType(columnId));
                    sqlDef.addColumn(columnId, metadata.getColumnType(columnId));
                }
                logger.info("Registered {} query successfully", (Object)queryDefinition.getName());
            }
            catch (DataSetLookupException e) {
                this.unregisterQuery(queryDefinition.getName());
                throw e;
            }
        }
    }

    public void unregisterQuery(String uniqueQueryName) throws QueryNotFoundException {
        DataSetDef def = this.dataSetDefRegistry.removeDataSetDef(uniqueQueryName);
        if (def == null) {
            throw new QueryNotFoundException("Query " + uniqueQueryName + " not found");
        }
        logger.info("Unregistered {} query successfully", (Object)uniqueQueryName);
    }

    public <T> T query(String queryName, QueryResultMapper<T> mapper, QueryContext queryContext, QueryParam ... filterParams) throws QueryNotFoundException {
        return this.query(queryName, mapper, queryContext, new CoreFunctionQueryParamBuilder(filterParams));
    }

    public <T> T query(String queryName, QueryResultMapper<T> mapper, QueryContext queryContext, QueryParamBuilder<?> paramBuilder) throws QueryNotFoundException {
        if (this.dataSetDefRegistry.getDataSetDef(queryName) == null) {
            throw new QueryNotFoundException("Query " + queryName + " not found");
        }
        logger.debug("About to query using {} definition with number of rows {} and starting at {} offset", new Object[]{queryName, queryContext.getCount(), queryContext.getOffset()});
        DataSetLookupBuilder builder = (DataSetLookupBuilder)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(queryName)).rowNumber(queryContext.getCount().intValue())).rowOffset(queryContext.getOffset().intValue());
        Object filter = paramBuilder.build();
        while (filter != null) {
            if (filter instanceof ColumnFilter) {
                builder.filter(new ColumnFilter[]{(ColumnFilter)filter});
            } else if (filter instanceof AggregateColumnFilter) {
                builder.column(((AggregateColumnFilter)filter).getColumnId(), ((AggregateColumnFilter)filter).getType(), ((AggregateColumnFilter)filter).getColumnId());
            } else if (filter instanceof GroupColumnFilter) {
                GroupColumnFilter groupFilter = (GroupColumnFilter)filter;
                builder.group(((GroupColumnFilter)filter).getColumnId(), ((GroupColumnFilter)filter).getNewColumnId());
                if (groupFilter.getIntervalSize() != null) {
                    ((AbstractDataSetLookupBuilder)builder).dynamic(groupFilter.getMaxIntervals(), DateIntervalType.valueOf((String)groupFilter.getIntervalSize()), true);
                }
            } else if (filter instanceof ExtraColumnFilter) {
                builder.column(((ExtraColumnFilter)filter).getColumnId(), ((ExtraColumnFilter)filter).getNewColumnId());
            } else {
                logger.warn("Unsupported filter '{}' generated by '{}'", filter, paramBuilder);
            }
            filter = paramBuilder.build();
        }
        if (queryContext instanceof AdvancedQueryContext && ((AdvancedQueryContext)queryContext).getOrderByClause() != null && !((AdvancedQueryContext)queryContext).getOrderByClause().isEmpty()) {
            String[] orderBySortOrderItems;
            for (String orderBySortOrderItem : orderBySortOrderItems = ((AdvancedQueryContext)queryContext).getOrderByClause().split(",")) {
                String[] orderBySortOrder = orderBySortOrderItem.trim().split(" ");
                String sortOrder = orderBySortOrder.length == 1 ? "asc" : orderBySortOrder[1].trim();
                logger.debug("Applying order by clause '{}' with {}ending sort order", (Object)orderBySortOrder[0].trim(), (Object)sortOrder);
                builder.sort(orderBySortOrder[0].trim(), sortOrder);
            }
        } else if (queryContext.getOrderBy() != null) {
            String[] oderByItems;
            for (String orderBy : oderByItems = queryContext.getOrderBy().split(",")) {
                logger.debug("Applying order by {} and ascending {}", (Object)orderBy, (Object)queryContext.isAscending());
                builder.sort(orderBy.trim(), queryContext.isAscending() != false ? "asc" : "desc");
            }
        }
        DataSet result = this.dataSetManager.lookupDataSet(builder.buildLookup());
        logger.debug("Query result is {}", (Object)result);
        Object mappedResult = mapper.map((Object)result);
        logger.debug("Mapped result is {}", mappedResult);
        return (T)mappedResult;
    }

    public QueryDefinition getQuery(String uniqueQueryName) throws QueryNotFoundException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", uniqueQueryName);
        List queries = (List)this.commandService.execute((Command)new QueryNameCommand("getQueryDefinitionByName", params));
        if (queries.size() == 1) {
            return ((QueryDefinitionEntity)queries.get(0)).toQueryDefinition();
        }
        throw new QueryNotFoundException("Query " + uniqueQueryName + " not found");
    }

    public List<QueryDefinition> getQueries(QueryContext queryContext) {
        ArrayList<QueryDefinition> result = new ArrayList<QueryDefinition>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        List queries = (List)this.commandService.execute((Command)new QueryNameCommand("getQueryDefinitions", params));
        for (QueryDefinitionEntity entity : queries) {
            QueryDefinition definition = entity.toQueryDefinition();
            result.add(definition);
        }
        return result;
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    public void onDeploy(DeploymentEvent event) {
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        List<String> roles = null;
        for (DeployedAsset asset : assets) {
            if (!(asset instanceof ProcessAssetDesc) || roles != null) continue;
            roles = ((ProcessAssetDesc)asset).getRoles();
        }
        if (roles == null) {
            roles = Collections.emptyList();
        }
        this.deploymentRolesManager.addRolesForDeployment(event.getDeploymentId(), roles);
    }

    public void onUnDeploy(DeploymentEvent event) {
        this.deploymentRolesManager.removeRolesForDeployment(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }
}

