/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.jbpm.persistence.api.PersistentCorrelationKey;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.kie.internal.jaxb.CorrelationKeyXmlAdapter;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@SequenceGenerator(name="correlationKeyInfoIdSeq", sequenceName="CORRELATION_KEY_ID_SEQ")
@Table(indexes={@Index(name="IDX_CorrelationKeyInfo_name", unique=true, columnList="name")})
public class CorrelationKeyInfo
implements PersistentCorrelationKey,
Serializable {
    private static final long serialVersionUID = 4469298702447675428L;
    private static final Logger logger = LoggerFactory.getLogger(CorrelationKeyInfo.class);
    @Transient
    private final int CORRELATION_KEY_LOG_LENGTH = Integer.parseInt(System.getProperty("org.jbpm.correlationkey.length", "255"));
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="correlationKeyInfoIdSeq")
    @Column(name="keyId")
    private long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private long processInstanceId;
    private String name;
    @OneToMany(mappedBy="correlationKey", cascade={CascadeType.ALL})
    private List<CorrelationPropertyInfo> properties;

    public String getName() {
        return this.name;
    }

    public List<CorrelationProperty<?>> getProperties() {
        return new ArrayList(this.properties);
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setName(String name) {
        this.name = this.trimString(name);
        if (this.name != null && this.name.length() < name.length()) {
            logger.warn("CorrelationKey content was trimmed as it was too long (more than {} characters)", (Object)this.CORRELATION_KEY_LOG_LENGTH);
        }
    }

    public void addProperty(CorrelationPropertyInfo property) {
        if (this.properties == null) {
            this.properties = new ArrayList<CorrelationPropertyInfo>();
        }
        property.setCorrelationKey(this);
        this.properties.add(property);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationKeyInfo other = (CorrelationKeyInfo)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "CorrelationKey [name=" + this.name + ", properties=" + this.properties + "]";
    }

    public long getId() {
        return this.id;
    }

    private String trimString(String name) {
        String trimmed = name;
        if (trimmed != null && trimmed.length() > this.CORRELATION_KEY_LOG_LENGTH) {
            trimmed = trimmed.substring(0, this.CORRELATION_KEY_LOG_LENGTH);
        }
        return trimmed;
    }

    public String toExternalForm() {
        return this.trimString(CorrelationKeyXmlAdapter.marshalCorrelationKey((CorrelationKey)this));
    }
}

