/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.jbpm.casemgmt.api.audit.CaseFileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@SequenceGenerator(name="caseFileDataLogIdSeq", sequenceName="CASE_FILE_DATA_LOG_ID_SEQ", allocationSize=1)
@Table(indexes={@Index(name="IDX_CaseFileDataLog_caseId", columnList="caseId"), @Index(name="IDX_CaseFileDataLog_itemName", columnList="itemName")})
public class CaseFileDataLog
implements Serializable,
CaseFileData {
    private static final Logger logger = LoggerFactory.getLogger(CaseFileDataLog.class);
    private static final long serialVersionUID = 7667968668409641210L;
    @Transient
    private final int VARIABLE_LOG_LENGTH = Integer.parseInt(System.getProperty("org.jbpm.cases.var.log.length", "255"));
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="caseFileDataLogIdSeq")
    private long id;
    private String caseId;
    private String caseDefId;
    private String itemName;
    private String itemValue;
    private String itemType;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified;
    private String lastModifiedBy;

    public CaseFileDataLog() {
    }

    public CaseFileDataLog(String caseId, String caseDefId, String itemName) {
        this.caseId = caseId;
        this.caseDefId = caseDefId;
        this.itemName = itemName;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseDefId() {
        return this.caseDefId;
    }

    public void setCaseDefId(String caseDefId) {
        this.caseDefId = caseDefId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemValue() {
        return this.itemValue;
    }

    public void setItemValue(String itemValue) {
        if (itemValue != null && itemValue.length() > this.VARIABLE_LOG_LENGTH) {
            itemValue = itemValue.substring(0, this.VARIABLE_LOG_LENGTH);
            logger.warn("Variable content was trimmed as it was too long (more than {} characters)", (Object)this.VARIABLE_LOG_LENGTH);
        }
        this.itemValue = itemValue;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseDefId == null ? 0 : this.caseDefId.hashCode());
        result = 31 * result + (this.caseId == null ? 0 : this.caseId.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.itemName == null ? 0 : this.itemName.hashCode());
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        result = 31 * result + (this.itemValue == null ? 0 : this.itemValue.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.lastModifiedBy == null ? 0 : this.lastModifiedBy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CaseFileDataLog other = (CaseFileDataLog)obj;
        if (this.caseDefId == null ? other.caseDefId != null : !this.caseDefId.equals(other.caseDefId)) {
            return false;
        }
        if (this.caseId == null ? other.caseId != null : !this.caseId.equals(other.caseId)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.itemName == null ? other.itemName != null : !this.itemName.equals(other.itemName)) {
            return false;
        }
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        if (this.itemValue == null ? other.itemValue != null : !this.itemValue.equals(other.itemValue)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        return !(this.lastModifiedBy == null ? other.lastModifiedBy != null : !this.lastModifiedBy.equals(other.lastModifiedBy));
    }

    public String toString() {
        return "CaseFileDataLog [id=" + this.id + ", caseId=" + this.caseId + ", caseDefId=" + this.caseDefId + ", itemName=" + this.itemName + ", itemValue=" + this.itemValue + ", itemType=" + this.itemType + ", lastModified=" + this.lastModified + ", lastModifiedBy=" + this.lastModifiedBy + "]";
    }
}

