/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogOrThrowWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogOrThrowWorkItemHandler.class);
    protected boolean logThrownException = false;
    protected String handlingProcessId;
    protected String handlingStrategy;
    protected int retries = Integer.parseInt(System.getProperty("org.jbpm.exception.handling_strategy.retry.count", "3"));

    public void setLogThrownException(boolean logException) {
        this.logThrownException = logException;
    }

    protected void handleException(Throwable cause) {
        this.handleException(cause, new HashMap<String, Object>());
    }

    protected void handleException(Throwable cause, Map<String, Object> handlerInfoMap) {
        if (this.canExceptionTriggerSubprocess(cause) && this.handlingProcessId != null && this.handlingStrategy != null) {
            throw new ProcessWorkItemHandlerException(this.handlingProcessId, this.handlingStrategy, cause, this.retries);
        }
        String service = (String)handlerInfoMap.get("Interface");
        String operation = (String)handlerInfoMap.get("Operation");
        if (!this.logThrownException) {
            WorkItemHandlerRuntimeException wihRe = new WorkItemHandlerRuntimeException(cause);
            for (String key : handlerInfoMap.keySet()) {
                wihRe.setInformation(key, handlerInfoMap.get(key));
            }
            wihRe.setInformation("workItemHandlerType", (Object)this.getClass().getSimpleName());
            throw wihRe;
        }
        String message = service != null ? this.getClass().getSimpleName() + " failed when calling " + service + "." + operation : this.getClass().getSimpleName() + " failed while trying to complete the task.";
        logger.error(message, cause);
    }

    private boolean canExceptionTriggerSubprocess(Throwable cause) {
        while (cause != null && !(cause instanceof PersistenceException)) {
            cause = cause.getCause();
        }
        return !(cause instanceof PersistenceException);
    }

    protected WorkItemNodeInstance findNodeInstance(long workItemId, NodeInstanceContainer container) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            WorkItemNodeInstance result;
            WorkItemNodeInstance workItemNodeInstance;
            if (nodeInstance instanceof WorkItemNodeInstance && (workItemNodeInstance = (WorkItemNodeInstance)nodeInstance).getWorkItem().getId() == workItemId) {
                return workItemNodeInstance;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer) || (result = this.findNodeInstance(workItemId, (NodeInstanceContainer)nodeInstance)) == null) continue;
            return result;
        }
        return null;
    }
}

