/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appformer.maven.integration.AbstractFilesArtifactResolver;
import org.appformer.maven.support.AFReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InJarArtifactResolver
extends AbstractFilesArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(InJarArtifactResolver.class);

    InJarArtifactResolver(ClassLoader classLoader, AFReleaseId releaseId) {
        super(classLoader, releaseId);
    }

    @Override
    protected List<URL> buildResources(Predicate<String> predicate) {
        URL resourceURL = this.getClassLoader().getResource("");
        ArrayList<URL> resources = new ArrayList<URL>();
        try (InputStream is = resourceURL.openStream();
             ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                if (!predicate.test(entry.getName())) continue;
                resources.add(this.getClassLoader().getResource(entry.getName()));
            }
            log.debug("Found in jar repository {}", resources);
        }
        catch (IOException e) {
            log.error("Error trying to open URL: {}", (Object)resourceURL);
        }
        return resources;
    }

    @Override
    protected URL getURL(String path) {
        return this.getClassLoader().getResource(path);
    }
}

