/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.runtime.manager.impl.mapper.InternalMapper;
import org.kie.api.runtime.manager.Context;

public class InMemoryMapper
extends InternalMapper {
    private Map<Object, Long> mapping = new ConcurrentHashMap<Object, Long>();

    public void saveMapping(Context<?> context, Long ksessionId, String ownerId) {
        this.mapping.put(context.getContextId(), ksessionId);
    }

    public Long findMapping(Context<?> context, String ownerId) {
        return this.mapping.get(context.getContextId());
    }

    public void removeMapping(Context<?> context, String ownerId) {
        this.mapping.remove(context.getContextId());
    }

    public Object findContextId(Long ksessionId, String ownerId) {
        if (this.mapping.containsValue(ksessionId)) {
            for (Map.Entry<Object, Long> entry : this.mapping.entrySet()) {
                if (!entry.getValue().equals(ksessionId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public boolean hasContext(Long ksessionId) {
        return ksessionId != null && this.mapping.containsValue(ksessionId);
    }

    @Override
    public List<String> findContextIdForEvent(String eventType, String ownerId) {
        ArrayList<String> contextIds = new ArrayList<String>();
        if (this.mapping != null && !this.mapping.isEmpty()) {
            for (Object contextId : this.mapping.keySet()) {
                contextIds.add(contextId.toString());
            }
        }
        return contextIds;
    }
}

