/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.admin.commands.AddPeopleAssignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.AddTaskInputsCommand;
import org.jbpm.kie.services.impl.admin.commands.CancelTaskDeadlineCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTaskNotificationsCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTaskReassignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.RemovePeopleAssignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.RemoveTaskDataCommand;
import org.jbpm.kie.services.impl.admin.commands.ScheduleTaskDeadlineCommand;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.jbpm.services.api.admin.TaskNotification;
import org.jbpm.services.api.admin.TaskReassignment;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;

public class UserTaskAdminServiceImpl
implements UserTaskAdminService {
    public static final int POT_OWNER = 0;
    public static final int EXCL_OWNER = 1;
    public static final int ADMIN = 2;
    private UserTaskService userTaskService;
    private RuntimeDataService runtimeDataService;
    private IdentityProvider identityProvider;
    private TransactionalCommandService commandService;

    public UserTaskAdminServiceImpl() {
        ServiceRegistry.get().register(UserTaskAdminService.class.getSimpleName(), (Object)this);
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void addPotentialOwners(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPotentialOwners(null, taskId, removeExisting, orgEntities);
    }

    public void addPotentialOwners(String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(deploymentId, taskId, removeExisting, 0, orgEntities);
    }

    public void addPotentialOwners(String userId, String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(userId, deploymentId, taskId, removeExisting, 0, orgEntities);
    }

    public void addExcludedOwners(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addExcludedOwners(null, taskId, removeExisting, orgEntities);
    }

    public void addExcludedOwners(String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(deploymentId, taskId, removeExisting, 1, orgEntities);
    }

    public void addExcludedOwners(String userId, String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(userId, deploymentId, taskId, removeExisting, 1, orgEntities);
    }

    public void addBusinessAdmins(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addBusinessAdmins(null, taskId, removeExisting, orgEntities);
    }

    public void addBusinessAdmins(String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(deploymentId, taskId, removeExisting, 2, orgEntities);
    }

    public void addBusinessAdmins(String userId, String deploymentId, long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(userId, deploymentId, taskId, removeExisting, 2, orgEntities);
    }

    public void removePotentialOwners(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePotentialOwners(null, taskId, orgEntities);
    }

    public void removePotentialOwners(String userId, String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(userId, deploymentId, taskId, 0, orgEntities);
    }

    public void removePotentialOwners(String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(deploymentId, taskId, 0, orgEntities);
    }

    public void removeExcludedOwners(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removeExcludedOwners(null, taskId, orgEntities);
    }

    public void removeExcludedOwners(String userId, String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(userId, deploymentId, taskId, 1, orgEntities);
    }

    public void removeExcludedOwners(String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(deploymentId, taskId, 1, orgEntities);
    }

    public void removeBusinessAdmins(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException, IllegalStateException {
        this.removeBusinessAdmins(null, taskId, orgEntities);
    }

    public void removeBusinessAdmins(String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException, IllegalStateException {
        this.removePeopleAssignment(deploymentId, taskId, 2, orgEntities);
    }

    public void removeBusinessAdmins(String userId, String deploymentId, long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException, IllegalStateException {
        this.removePeopleAssignment(userId, deploymentId, taskId, 2, orgEntities);
    }

    public void addTaskInput(long taskId, String name, Object value) throws TaskNotFoundException {
        this.addTaskInput(null, taskId, name, value);
    }

    public void addTaskInput(String deploymentId, long taskId, String name, Object value) throws TaskNotFoundException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(name, value);
        this.addTaskInputs(deploymentId, taskId, data);
    }

    public void addTaskInputs(long taskId, Map<String, Object> data) throws TaskNotFoundException {
        this.addTaskInputs(null, taskId, data);
    }

    public void addTaskInputs(String deploymentId, long taskId, Map<String, Object> data) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new AddTaskInputsCommand(this.identityProvider.getName(), taskId, data));
    }

    public void removeTaskInputs(long taskId, String ... name) throws TaskNotFoundException {
        this.removeTaskInputs(null, taskId, name);
    }

    public void removeTaskInputs(String deploymentId, long taskId, String ... name) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemoveTaskDataCommand(this.identityProvider.getName(), taskId, Arrays.asList(name), true));
    }

    public void removeTaskOutputs(long taskId, String ... name) throws TaskNotFoundException {
        this.removeTaskOutputs(null, taskId, name);
    }

    public void removeTaskOutputs(String deploymentId, long taskId, String ... name) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemoveTaskDataCommand(this.identityProvider.getName(), taskId, Arrays.asList(name), false));
    }

    public Long reassignWhenNotStarted(long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassignWhenNotStarted(null, taskId, timeExpression, orgEntities);
    }

    public Long reassignWhenNotStarted(String deploymentId, long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassign(deploymentId, taskId, timeExpression, TaskDeadlinesService.DeadlineType.START, orgEntities);
    }

    public Long reassignWhenNotCompleted(long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassignWhenNotCompleted(null, taskId, timeExpression, orgEntities);
    }

    public Long reassignWhenNotCompleted(String deploymentId, long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassign(deploymentId, taskId, timeExpression, TaskDeadlinesService.DeadlineType.END, orgEntities);
    }

    public Long notifyWhenNotStarted(long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notifyWhenNotStarted(null, taskId, timeExpression, notification);
    }

    public Long notifyWhenNotStarted(String deploymentId, long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notify(deploymentId, taskId, timeExpression, TaskDeadlinesService.DeadlineType.START, notification);
    }

    public Long notifyWhenNotCompleted(long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notifyWhenNotCompleted(null, taskId, timeExpression, notification);
    }

    public Long notifyWhenNotCompleted(String deploymentId, long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notify(deploymentId, taskId, timeExpression, TaskDeadlinesService.DeadlineType.END, notification);
    }

    public Collection<TaskReassignment> getTaskReassignments(long taskId, boolean activeOnly) throws TaskNotFoundException {
        return this.getTaskReassignments(null, taskId, activeOnly);
    }

    public Collection<TaskReassignment> getTaskReassignments(String deploymentId, long taskId, boolean activeOnly) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        return (Collection)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ListTaskReassignmentsCommand(this.identityProvider.getName(), taskId, activeOnly));
    }

    public Collection<TaskNotification> getTaskNotifications(long taskId, boolean activeOnly) throws TaskNotFoundException {
        return this.getTaskNotifications(null, taskId, activeOnly);
    }

    public Collection<TaskNotification> getTaskNotifications(String deploymentId, long taskId, boolean activeOnly) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        return (Collection)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ListTaskNotificationsCommand(this.identityProvider.getName(), taskId, activeOnly));
    }

    public void cancelNotification(long taskId, long notificationId) throws TaskNotFoundException {
        this.cancelNotification(null, taskId, notificationId);
    }

    public void cancelNotification(String deploymentId, long taskId, long notificationId) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new CancelTaskDeadlineCommand(this.identityProvider.getName(), taskId, notificationId));
    }

    public void cancelReassignment(long taskId, long reassignmentId) throws TaskNotFoundException {
        this.cancelReassignment(null, taskId, reassignmentId);
    }

    public void cancelReassignment(String deploymentId, long taskId, long reassignmentId) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new CancelTaskDeadlineCommand(this.identityProvider.getName(), taskId, reassignmentId));
    }

    public EmailNotification buildEmailNotification(String subjectStr, List<OrganizationalEntity> recipients, String bodyStr, String fromStr, String replyToStr) {
        EmailNotification emailNotification = TaskModelProvider.getFactory().newEmialNotification();
        HashMap<Language, EmailNotificationHeader> emailHeaders = new HashMap<Language, EmailNotificationHeader>();
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        String locale = "en-UK";
        EmailNotificationHeader emailHeader = TaskModelProvider.getFactory().newEmailNotificationHeader();
        emailHeader.setBody(bodyStr);
        emailHeader.setFrom(fromStr);
        emailHeader.setReplyTo(replyToStr);
        emailHeader.setLanguage(locale);
        emailHeader.setSubject(subjectStr);
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey(locale);
        emailHeaders.put(lang, emailHeader);
        I18NText subject = TaskModelProvider.getFactory().newI18NText();
        ((InternalI18NText)subject).setLanguage(locale);
        ((InternalI18NText)subject).setText(emailHeader.getSubject());
        subjects.add(subject);
        names.add(subject);
        emailNotification.setEmailHeaders(emailHeaders);
        emailNotification.setNames(names);
        emailNotification.setRecipients(new ArrayList<OrganizationalEntity>(recipients));
        emailNotification.setSubjects(subjects);
        return emailNotification;
    }

    public List<ExecutionError> getErrors(boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskErrors", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByTaskId(long taskId, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByTaskId", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByTaskName(String taskName, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskName", taskName);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByTaskName", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByTaskName(String processId, String taskName, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("taskName", taskName);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByTaskNameProcessId", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByTaskName(String deploymentId, String processId, String taskName, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("processId", processId);
        params.put("taskName", taskName);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByTaskNameProcessIdDeploymentId", params));
        return execErrors;
    }

    public void acknowledgeError(String ... errorId) throws ExecutionErrorNotFoundException {
        for (String error : errorId) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("errorId", error);
            params.put("ack", new Short("0"));
            List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorById", params));
            if (execErrors.isEmpty()) {
                throw new ExecutionErrorNotFoundException("No execution error found for id " + errorId);
            }
            ExecutionError errorInstance = (ExecutionError)execErrors.get(0);
            RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(errorInstance.getDeploymentId());
            if (runtimeManager == null) continue;
            ((AbstractRuntimeManager)runtimeManager).getExecutionErrorManager().getStorage().acknowledge(this.identityProvider.getName(), new String[]{errorInstance.getErrorId()});
        }
    }

    public ExecutionError getError(String errorId) throws ExecutionErrorNotFoundException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("errorId", errorId);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorByIdSkipAckCheck", params));
        if (execErrors.isEmpty()) {
            throw new ExecutionErrorNotFoundException("No execution error found for id " + errorId);
        }
        ExecutionError error = (ExecutionError)execErrors.get(0);
        return error;
    }

    protected void addPeopleAssignment(String userId, String deploymentId, long taskId, boolean removeExisting, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new AddPeopleAssignmentsCommand(userId, taskId, type, orgEntities, removeExisting));
    }

    protected void addPeopleAssignment(String deploymentId, long taskId, boolean removeExisting, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new AddPeopleAssignmentsCommand(this.identityProvider.getName(), taskId, type, orgEntities, removeExisting));
    }

    protected void removePeopleAssignment(String userId, String deploymentId, long taskId, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemovePeopleAssignmentsCommand(userId, taskId, type, orgEntities));
    }

    protected void removePeopleAssignment(String deploymentId, long taskId, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemovePeopleAssignmentsCommand(this.identityProvider.getName(), taskId, type, orgEntities));
    }

    protected Long reassign(String deploymentId, long taskId, String timeExpression, TaskDeadlinesService.DeadlineType type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        if (timeExpression == null || timeExpression.isEmpty()) {
            throw new IllegalArgumentException("Invalid time expression");
        }
        if (orgEntities == null || orgEntities.length <= 0) {
            throw new IllegalArgumentException("Invalid org entity");
        }
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        Deadline taskDeadline = TaskModelProvider.getFactory().newDeadline();
        taskDeadline.setEscalations(escalations);
        Escalation escalation = TaskModelProvider.getFactory().newEscalation();
        escalations.add(escalation);
        escalation.setName("Admin reassignment for task " + taskId);
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        Reassignment reassignment = TaskModelProvider.getFactory().newReassignment();
        reassignment.setPotentialOwners(new ArrayList<OrganizationalEntity>(Arrays.asList(orgEntities)));
        reassignments.add(reassignment);
        escalation.setReassignments(reassignments);
        return (Long)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ScheduleTaskDeadlineCommand(this.identityProvider.getName(), taskId, type, taskDeadline, timeExpression));
    }

    protected Long notify(String deploymentId, long taskId, String timeExpression, TaskDeadlinesService.DeadlineType type, Notification notification) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        this.validateTask(deploymentId, taskId, task);
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        Deadline taskDeadline = TaskModelProvider.getFactory().newDeadline();
        taskDeadline.setEscalations(escalations);
        Escalation escalation = TaskModelProvider.getFactory().newEscalation();
        escalations.add(escalation);
        escalation.setName("Admin notification for task " + taskId);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        notifications.add(notification);
        escalation.setNotifications(notifications);
        return (Long)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ScheduleTaskDeadlineCommand(this.identityProvider.getName(), taskId, type, taskDeadline, timeExpression));
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected List<Short> getAckMode(boolean includeAcknowledged) {
        ArrayList<Short> ackMode = new ArrayList<Short>();
        ackMode.add(new Short("0"));
        if (includeAcknowledged) {
            ackMode.add(new Short("1"));
        }
        return ackMode;
    }

    protected void validateTask(String deploymentId, Long taskId, UserTaskInstanceDesc task) {
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        if (deploymentId != null && !task.getDeploymentId().equals(deploymentId)) {
            throw new TaskNotFoundException("Task with id " + taskId + " is not associated with " + deploymentId);
        }
    }
}

