/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.impl.util.HumanTaskHandlerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.InternalTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlineSchedulerHelper {
    private static final Logger logger = LoggerFactory.getLogger(DeadlineSchedulerHelper.class);

    private DeadlineSchedulerHelper() {
    }

    public static void rescheduleDeadlinesForTask(InternalTask task, TaskContext taskContext, boolean unboundRepeatableOnly, TaskDeadlinesService.DeadlineType ... types) {
        DeadlineSchedulerHelper.rescheduleDeadlinesForTask(task, taskContext, unboundRepeatableOnly, null, types);
    }

    public static void rescheduleDeadlinesForTask(InternalTask task, TaskContext taskContext, boolean unboundRepeatableOnly, Deadline triggered, TaskDeadlinesService.DeadlineType ... types) {
        Environment environment = taskContext.getTaskContentService().getMarshallerContext((Task)task).getEnvironment();
        TaskPersistenceContext persistenceContext = taskContext.getPersistenceContext();
        taskContext.loadTaskVariables((Task)task);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        List<TaskDeadlinesService.DeadlineType> deadlineTypes = Arrays.asList(types);
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines(task.getTaskData().getTaskInputVariables(), businessAdministrators, environment, unboundRepeatableOnly);
        if (deadlines.getStartDeadlines().isEmpty() && deadlines.getEndDeadlines().isEmpty()) {
            return;
        }
        TaskDeadlinesService deadlineService = taskContext.getTaskDeadlinesService();
        if (deadlineTypes.contains(TaskDeadlinesService.DeadlineType.START)) {
            logger.debug("Assigning START deadlines {}", (Object)deadlines.getStartDeadlines());
            DeadlineSchedulerHelper.scheduleDeadlines(DeadlineSchedulerHelper.cleanDeadlines(deadlines.getStartDeadlines(), task.getDeadlines().getStartDeadlines(), triggered, persistenceContext), System.currentTimeMillis(), task.getId(), TaskDeadlinesService.DeadlineType.START, deadlineService);
        }
        if (deadlineTypes.contains(TaskDeadlinesService.DeadlineType.END)) {
            logger.debug("Assigning END deadlines {}", (Object)deadlines.getEndDeadlines());
            DeadlineSchedulerHelper.scheduleDeadlines(DeadlineSchedulerHelper.cleanDeadlines(deadlines.getEndDeadlines(), task.getDeadlines().getEndDeadlines(), triggered, persistenceContext), System.currentTimeMillis(), task.getId(), TaskDeadlinesService.DeadlineType.END, deadlineService);
        }
        persistenceContext.updateTask((Task)task);
    }

    private static List<Deadline> cleanDeadlines(List<Deadline> parsedDeadlines, List<Deadline> deadlines, Deadline triggered, TaskPersistenceContext persistenceContext) {
        ArrayList<Deadline> result = new ArrayList<Deadline>();
        for (Deadline deadline : parsedDeadlines) {
            if (triggered != null && !deadline.getEscalations().equals(triggered.getEscalations())) continue;
            Iterator<Deadline> iter = deadlines.iterator();
            boolean found = false;
            while (!found && iter.hasNext()) {
                Deadline candidate = iter.next();
                if (!deadline.getEscalations().equals(candidate.getEscalations())) continue;
                found = true;
                iter.remove();
                persistenceContext.remove((Object)candidate);
            }
            if (!found) continue;
            result.add(deadline);
            deadlines.add(deadline);
            persistenceContext.persistDeadline(deadline);
        }
        return result;
    }

    public static void scheduleDeadlinesForTask(InternalTask task, TaskContext taskContext, TaskDeadlinesService.DeadlineType ... types) {
        TaskDeadlinesService deadlineService = taskContext.getTaskDeadlinesService();
        long now = System.currentTimeMillis();
        List<TaskDeadlinesService.DeadlineType> deadlineTypes = Arrays.asList(types);
        Deadlines deadlines = task.getDeadlines();
        if (deadlines != null) {
            List endDeadlines;
            List startDeadlines = deadlines.getStartDeadlines();
            if (startDeadlines != null && deadlineTypes.contains(TaskDeadlinesService.DeadlineType.START)) {
                DeadlineSchedulerHelper.scheduleDeadlines(startDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.START, deadlineService);
            }
            if ((endDeadlines = deadlines.getEndDeadlines()) != null && deadlineTypes.contains(TaskDeadlinesService.DeadlineType.END)) {
                DeadlineSchedulerHelper.scheduleDeadlines(endDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.END, deadlineService);
            }
        }
    }

    public static void scheduleDeadlines(List<? extends Deadline> deadlines, long now, long taskId, TaskDeadlinesService.DeadlineType type, TaskDeadlinesService deadlineService) {
        for (Deadline deadline : deadlines) {
            if (!Boolean.FALSE.equals(deadline.isEscalated())) continue;
            Date date = deadline.getDate();
            deadlineService.scheduleNew(taskId, deadline.getId(), date.getTime() - now, type);
        }
    }
}

