/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class AddDataSourceCommand<E>
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = -5255184977368094272L;
    private final Class<E> clazz;
    private final List<String> names;
    private final DataSource<E> values;

    public AddDataSourceCommand(Class<E> clazz, List<String> names, DataSource<E> values) {
        this.clazz = clazz;
        this.names = names;
        this.values = values;
    }

    @Override
    public Void execute(Context context) {
        RuleUnitExecutor ruleUnitExecutor = ((RegistryContext)context).lookup(RuleUnitExecutor.class);
        if (ruleUnitExecutor == null) {
            throw new RuntimeException("No RuleUnitExecutor is present in the Registry");
        }
        for (String name : this.names) {
            ruleUnitExecutor.bindVariable(name, this.values);
        }
        return null;
    }

    public String toString() {
        return "GenericExpressionVarBindingCommand{names='" + this.names.stream().collect(Collectors.joining(",")) + "'}";
    }
}

