/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;

public class DataSetProviderRegistryImpl
implements DataSetProviderRegistry {
    private Map<String, DataSetProvider> dataSetProviderMap = new HashMap<String, DataSetProvider>();
    private Set<DataSetProviderType> availableTypes = new HashSet<DataSetProviderType>();

    public void registerDataProvider(DataSetProvider dataProvider) {
        DataSetProviderType type = dataProvider.getType();
        this.dataSetProviderMap.put(type.getName(), dataProvider);
        this.availableTypes.add(type);
    }

    public DataSetProvider getDataSetProvider(DataSetProviderType type) {
        return this.dataSetProviderMap.get(type.getName());
    }

    public Set<DataSetProviderType> getAvailableTypes() {
        return this.availableTypes;
    }

    public DataSetProviderType getProviderTypeByName(String name) {
        DataSetProvider provider = this.dataSetProviderMap.get(name);
        return provider != null ? provider.getType() : null;
    }
}

