/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.NamedElement;

public class DecisionCompiler
implements DRGElementCompiler {
    @Override
    public boolean accept(DRGElement de) {
        return de instanceof Decision;
    }

    @Override
    public void compileNode(DRGElement de, DMNCompilerImpl compiler, DMNModelImpl model) {
        Decision decision = (Decision)de;
        DecisionNodeImpl dn = new DecisionNodeImpl(decision);
        DMNType type = null;
        if (decision.getVariable() == null) {
            DMNCompilerHelper.reportMissingVariable(model, de, (DMNModelInstrumentedBase)decision, Msg.MISSING_VARIABLE_FOR_DECISION);
            return;
        }
        DMNCompilerHelper.checkVariableName(model, (NamedElement)decision, decision.getName());
        type = decision.getVariable() != null && decision.getVariable().getTypeRef() != null ? compiler.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision.getVariable(), decision.getVariable().getTypeRef()) : compiler.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision, null);
        dn.setResultType(type);
        model.addDecision(dn);
    }

    @Override
    public boolean accept(DMNNode node) {
        return node instanceof DecisionNodeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
        DecisionNodeImpl di = (DecisionNodeImpl)node;
        compiler.linkRequirements(model, di);
        ctx.enterFrame();
        try {
            HashMap<String, DMNType> importedTypes = new HashMap<String, DMNType>();
            for (DMNNode dMNNode : di.getDependencies().values()) {
                CompositeTypeImpl importedComposite;
                Optional<String> alias;
                if (dMNNode instanceof DecisionNode) {
                    if (dMNNode.getModelNamespace().equals(model.getNamespace())) {
                        ctx.setVariable(dMNNode.getName(), ((DecisionNode)dMNNode).getResultType());
                        continue;
                    }
                    alias = model.getImportAliasFor(dMNNode.getModelNamespace(), dMNNode.getModelName());
                    if (!alias.isPresent()) continue;
                    importedComposite = (CompositeTypeImpl)importedTypes.computeIfAbsent(alias.get(), a -> new CompositeTypeImpl());
                    importedComposite.addField(dMNNode.getName(), ((DecisionNode)dMNNode).getResultType());
                    continue;
                }
                if (dMNNode instanceof InputDataNode) {
                    ctx.setVariable(dMNNode.getName(), ((InputDataNode)dMNNode).getType());
                    continue;
                }
                if (!(dMNNode instanceof BusinessKnowledgeModelNode)) continue;
                if (dMNNode.getModelNamespace().equals(model.getNamespace())) {
                    ctx.setVariable(dMNNode.getName(), ((BusinessKnowledgeModelNode)dMNNode).getResultType());
                    continue;
                }
                alias = model.getImportAliasFor(dMNNode.getModelNamespace(), dMNNode.getModelName());
                if (!alias.isPresent()) continue;
                importedComposite = (CompositeTypeImpl)importedTypes.computeIfAbsent(alias.get(), a -> new CompositeTypeImpl());
                importedComposite.addField(dMNNode.getName(), ((BusinessKnowledgeModelNode)dMNNode).getResultType());
            }
            for (Map.Entry entry : importedTypes.entrySet()) {
                ctx.setVariable((String)entry.getKey(), (DMNType)entry.getValue());
            }
            DMNExpressionEvaluator evaluator = compiler.getEvaluatorCompiler().compileExpression(ctx, model, di, di.getName(), di.getDecision().getExpression());
            di.setEvaluator(evaluator);
        }
        finally {
            ctx.exitFrame();
        }
    }
}

