/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonBoolean;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonNull;
import org.dashbuilder.json.JsonNumber;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonString;
import org.dashbuilder.json.JsonTokenizer;
import org.dashbuilder.json.JsonValue;

public class JsonFactory {
    public JsonString create(String string) {
        return new JsonString(string);
    }

    public JsonNumber create(double number) {
        return new JsonNumber(number);
    }

    public JsonBoolean create(boolean bool) {
        return new JsonBoolean(bool);
    }

    public JsonArray createArray() {
        return new JsonArray(this);
    }

    public JsonNull createNull() {
        return JsonNull.NULL_INSTANCE;
    }

    public JsonObject createObject() {
        return new JsonObject(this);
    }

    public <T extends JsonValue> T parse(String jsonString) throws JsonException {
        if (jsonString.startsWith("(") && jsonString.endsWith(")")) {
            jsonString = jsonString.substring(1, jsonString.length() - 1);
        }
        return new JsonTokenizer(this, jsonString).nextValue();
    }
}

