/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Expression;
import org.kie.dmn.model.v1_1.FunctionDefinition;
import org.kie.dmn.model.v1_1.NamedElement;

public class BusinessKnowledgeModelCompiler
implements DRGElementCompiler {
    @Override
    public boolean accept(DRGElement de) {
        return de instanceof BusinessKnowledgeModel;
    }

    @Override
    public void compileNode(DRGElement de, DMNCompilerImpl compiler, DMNModelImpl model) {
        BusinessKnowledgeModel bkm = (BusinessKnowledgeModel)de;
        BusinessKnowledgeModelNodeImpl bkmn = new BusinessKnowledgeModelNodeImpl(bkm);
        DMNType type = null;
        if (bkm.getVariable() == null) {
            DMNCompilerHelper.reportMissingVariable(model, (NamedElement)de, (DMNModelInstrumentedBase)bkm, Msg.MISSING_VARIABLE_FOR_BKM);
            return;
        }
        DMNCompilerHelper.checkVariableName(model, (NamedElement)bkm, bkm.getName());
        type = bkm.getVariable() != null && bkm.getVariable().getTypeRef() != null ? compiler.resolveTypeRef(model, (NamedElement)bkm, (DMNModelInstrumentedBase)bkm.getVariable(), bkm.getVariable().getTypeRef()) : compiler.resolveTypeRef(model, (NamedElement)bkm, (DMNModelInstrumentedBase)bkm, null);
        bkmn.setResultType(type);
        model.addBusinessKnowledgeModel(bkmn);
    }

    @Override
    public boolean accept(DMNNode node) {
        return node instanceof BusinessKnowledgeModelNodeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
        BusinessKnowledgeModelNodeImpl bkmi = (BusinessKnowledgeModelNodeImpl)node;
        compiler.linkRequirements(model, bkmi);
        ctx.enterFrame();
        try {
            for (DMNNode dep : bkmi.getDependencies().values()) {
                if (dep instanceof BusinessKnowledgeModelNode) {
                    ctx.setVariable(dep.getName(), ((BusinessKnowledgeModelNode)dep).getResultType());
                    continue;
                }
                if (!(dep instanceof DecisionServiceNode)) continue;
                ctx.setVariable(dep.getName(), ((DecisionServiceNode)dep).getResultType());
            }
            ctx.setVariable(bkmi.getName(), bkmi.getResultType());
            FunctionDefinition funcDef = bkmi.getBusinessKnowledModel().getEncapsulatedLogic();
            DMNExpressionEvaluator exprEvaluator = compiler.getEvaluatorCompiler().compileExpression(ctx, model, bkmi, bkmi.getName(), (Expression)funcDef);
            bkmi.setEvaluator(exprEvaluator);
        }
        finally {
            ctx.exitFrame();
        }
    }
}

