/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.kie.api.command.Command;
import org.kie.internal.executor.api.CommandCallback;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.STATUS;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorRunnable.class);
    @Inject
    private ExecutorQueryService queryService;
    @Inject
    private ClassCacheManager classCacheManager;
    @Inject
    private TransactionalCommandService commandService;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            logger.debug("Executor Thread {} Waking Up!!!", (Object)this.toString());
            try {
                RequestInfo request = (RequestInfo)this.queryService.getRequestForProcessing();
                if (request == null) break block20;
                CommandContext ctx = null;
                List<CommandCallback> callbacks = null;
                try {
                    logger.debug("Processing Request Id: {}, status {} command {}", new Object[]{request.getId(), request.getStatus(), request.getCommandName()});
                    ClassLoader cl = this.getClassLoader(request.getDeploymentId());
                    byte[] reqData = request.getRequestData();
                    if (reqData != null) {
                        ObjectInputStream in = null;
                        try {
                            in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                            ctx = (CommandContext)in.readObject();
                        }
                        catch (IOException e) {
                            logger.warn("Exception while serializing context data", (Throwable)e);
                            return;
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                    org.kie.internal.executor.api.Command cmd = this.classCacheManager.findCommand(request.getCommandName(), cl);
                    ExecutionResults results = cmd.execute(ctx);
                    for (CommandCallback handler : callbacks) {
                        handler.onCommandDone(ctx, results);
                    }
                    if (results != null) {
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            ObjectOutputStream out = new ObjectOutputStream(bout);
                            out.writeObject(results);
                            byte[] respData = bout.toByteArray();
                            request.setResponseData(respData);
                        }
                        catch (IOException e) {
                            request.setResponseData(null);
                        }
                    }
                    request.setStatus(STATUS.DONE);
                    this.commandService.execute((Command)new MergeObjectCommand(new Object[]{request}));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    logger.warn("Error during command {} execution {}", (Object)request.getCommandName(), (Object)e.getMessage());
                    ErrorInfo errorInfo = new ErrorInfo(e.getMessage(), ExceptionUtils.getFullStackTrace((Throwable)e.fillInStackTrace()));
                    errorInfo.setRequestInfo(request);
                    request.getErrorInfo().add(errorInfo);
                    logger.debug("Error Number: {}", (Object)request.getErrorInfo().size());
                    if (request.getRetries() > 0) {
                        request.setStatus(STATUS.RETRYING);
                        request.setRetries(request.getRetries() - 1);
                        request.setExecutions(request.getExecutions() + 1);
                        logger.debug("Retrying ({}) still available!", (Object)request.getRetries());
                        this.commandService.execute((Command)new MergeObjectCommand(new Object[]{request}));
                    } else {
                        logger.debug("Error no retries left!");
                        request.setStatus(STATUS.ERROR);
                        request.setExecutions(request.getExecutions() + 1);
                        this.commandService.execute((Command)new MergeObjectCommand(new Object[]{request}));
                        if (callbacks != null) {
                            for (CommandCallback handler : callbacks) {
                                handler.onCommandError(ctx, e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected error while processin executor's job {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ClassLoader getClassLoader(String deploymentId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deploymentId == null) {
            return cl;
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(deploymentId);
        if (manager != null && manager.getEnvironment().getClassLoader() != null) {
            cl = manager.getEnvironment().getClassLoader();
        }
        return cl;
    }
}

