/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.mem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.executor.impl.mem.InMemoryExecutorStoreService;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;

public class InMemoryExecutorQueryServiceImpl
implements ExecutorQueryService {
    private InMemoryExecutorStoreService storeService;

    public void setStoreService(InMemoryExecutorStoreService storeService) {
        this.storeService = storeService;
    }

    public InMemoryExecutorQueryServiceImpl(boolean active) {
    }

    public List<RequestInfo> getPendingRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.QUEUED, STATUS.RETRYING));
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        ArrayList<RequestInfo> requests = new ArrayList<RequestInfo>();
        RequestInfo request = this.storeService.findRequest(id);
        if (request != null && request.getStatus() == STATUS.QUEUED) {
            requests.add(request);
        }
        return requests;
    }

    public RequestInfo getRequestById(Long id) {
        return this.storeService.findRequest(id);
    }

    public List<RequestInfo> getRequestByBusinessKey(String businessKey) {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByKey(businessKey));
    }

    public List<ErrorInfo> getErrorsByRequestId(Long id) {
        return this.storeService.findRequest(id).getErrorInfo();
    }

    public List<RequestInfo> getQueuedRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.QUEUED));
    }

    public List<RequestInfo> getCompletedRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.DONE));
    }

    public List<RequestInfo> getInErrorRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsWitError());
    }

    public List<RequestInfo> getCancelledRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.CANCELLED));
    }

    public List<ErrorInfo> getAllErrors() {
        return new ArrayList<ErrorInfo>(this.storeService.getErrors().values());
    }

    public List<RequestInfo> getAllRequests() {
        HashMap<Long, RequestInfo> requests = new HashMap<Long, RequestInfo>(this.storeService.getRequests());
        requests.putAll(this.storeService.getProcessedRequests());
        return new ArrayList<RequestInfo>(requests.values());
    }

    public List<RequestInfo> getRunningRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.RUNNING));
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return this.getQueuedRequests();
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        HashMap<Long, RequestInfo> requests = new HashMap<Long, RequestInfo>(this.storeService.getRequests());
        requests.putAll(this.storeService.getProcessedRequests());
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(statuses));
    }

    public RequestInfo getRequestForProcessing() {
        return this.storeService.getAndLockFirst();
    }

    private class GetRequestsWitError
    implements Predicate {
        GetRequestsWitError() {
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && !((RequestInfo)object).getErrorInfo().isEmpty();
        }
    }

    private class GetRequestsByKey
    implements Predicate {
        private String key;

        GetRequestsByKey(String key) {
            this.key = key;
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && this.key.equals(((RequestInfo)object).getKey());
        }
    }

    private class GetRequestsByStatus
    implements Predicate {
        private List<STATUS> statuses;

        GetRequestsByStatus(STATUS ... status) {
            this.statuses = Arrays.asList(status);
        }

        GetRequestsByStatus(List<STATUS> statuses) {
            this.statuses = statuses;
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && this.statuses.contains(((RequestInfo)object).getStatus());
        }
    }
}

