/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.query.QueryContext;

public class ReconfiguredExecutorTest {
    protected ExecutorService executorService;
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();
    private PoolingDataSource pds;
    private EntityManagerFactory emf = null;

    @Before
    public void setUp() {
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setThreadPoolSize(2);
        this.executorService.setInterval(3000);
        this.executorService.setTimeunit(TimeUnit.MILLISECONDS);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test
    public void simpleExcecutionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }
}

