/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class CleanupLogCommandWithProcessTest
extends AbstractExecutorBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test
    public void testRunProcessWithAsyncHandler() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)0L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        Date startDate = new Date();
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)5L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        this.scheduleLogCleanup(false, true, false, startDate, "ScriptTask", "yyyy-MM-dd", this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        System.out.println("Aborting process instance " + processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)5L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)6L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        Thread.sleep(1000L);
        this.scheduleLogCleanup(false, false, false, new Date(), "ScriptTask", "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        Assert.assertEquals((long)0L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
    }

    @Test
    public void testRunProcessWithAsyncHandlerDontDeleteActive() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)0L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        Date startDate = new Date();
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)5L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        this.scheduleLogCleanup(false, true, false, startDate, "ScriptTask", "yyyy-MM-dd", this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        System.out.println("Aborting process instance " + processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)5L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)6L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)11L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
        Thread.sleep(1000L);
        this.scheduleLogCleanup(false, false, false, new Date(), "ScriptTask", "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("ScriptTask"));
        Assert.assertEquals((long)5L, (long)this.getNodeInstanceLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("ScriptTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("ScriptTask"));
    }

    @Test
    public void testCleanupLogOfUserTaskProcess() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLA.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)0L, (long)this.getProcessLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getNodeInstanceLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskVariableLogSize("UserTask"));
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("UserTask"));
        Assert.assertEquals((long)3L, (long)this.getNodeInstanceLogSize("UserTask"));
        Assert.assertEquals((long)1L, (long)this.getTaskLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskVariableLogSize("UserTask"));
        List tasks = runtime.getTaskService().getTasksByProcessInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = (Long)tasks.get(0);
        runtime.getTaskService().start(taskId, "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("test", "testvalue");
        runtime.getTaskService().complete(taskId, "john", results);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)this.getProcessLogSize("UserTask"));
        Assert.assertEquals((long)6L, (long)this.getNodeInstanceLogSize("UserTask"));
        Assert.assertEquals((long)1L, (long)this.getTaskLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("UserTask"));
        Assert.assertEquals((long)1L, (long)this.getTaskVariableLogSize("UserTask"));
        Thread.sleep(1000L);
        this.scheduleLogCleanup(false, false, false, new Date(), "UserTask", "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        Assert.assertEquals((long)0L, (long)this.getProcessLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getNodeInstanceLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getVariableLogSize("UserTask"));
        Assert.assertEquals((long)0L, (long)this.getTaskVariableLogSize("UserTask"));
    }

    private ExecutorService buildExecutorService() {
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }

    private void scheduleLogCleanup(boolean skipProcessLog, boolean skipTaskLog, boolean skipExecutorLog, Date olderThan, String forProcess, String dateFormat, String identifier) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        commandContext.setData("SkipProcessLog", (Object)String.valueOf(skipProcessLog));
        commandContext.setData("SkipTaskLog", (Object)String.valueOf(skipTaskLog));
        commandContext.setData("SkipExecutorLog", (Object)String.valueOf(skipExecutorLog));
        commandContext.setData("SingleRun", (Object)"true");
        commandContext.setData("OlderThan", (Object)new SimpleDateFormat(dateFormat).format(olderThan));
        commandContext.setData("DateFormat", (Object)dateFormat);
        commandContext.setData("ForDeployment", (Object)identifier);
        commandContext.setData("ForProcess", (Object)forProcess);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", commandContext);
    }

    private int getProcessLogSize(String processId) {
        return ((ProcessInstanceLogQueryBuilder)new JPAAuditLogService(this.emf).processInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getTaskLogSize(String processId) {
        return new TaskJPAAuditService(this.emf).auditTaskQuery().processId(new String[]{processId}).build().getResultList().size();
    }

    private int getNodeInstanceLogSize(String processId) {
        return ((NodeInstanceLogQueryBuilder)new JPAAuditLogService(this.emf).nodeInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getVariableLogSize(String processId) {
        return ((VariableInstanceLogQueryBuilder)new JPAAuditLogService(this.emf).variableInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getTaskVariableLogSize(String processId) {
        return new TaskJPAAuditService(this.emf).taskVariableQuery().processId(new String[]{processId}).build().getResultList().size();
    }
}

