/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class CleanupExecutionErrorCommandWithProcessTest
extends AbstractExecutorBaseTest {
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=30000L)
    public void testRunProcessWithAsyncHandlerDeleteUsingOlderThan() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = this.configureEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        ExecutionErrorStorage errorStorage = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager().getStorage();
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Date startDate = new Date();
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        this.scheduleLogCleanup(startDate, null, true, null, "ScriptTask", String.valueOf(processInstanceId), "yyyy-MM-dd", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        System.out.println("Aborting process instance " + processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        Thread.sleep(1000L);
        this.scheduleLogCleanup(new Date(), null, true, null, "ScriptTask", String.valueOf(processInstanceId), "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    @Test(timeout=30000L)
    public void testRunProcessWithAsyncHandlerDeleteUsingOlderThanPeriod() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = this.configureEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        ExecutionErrorStorage errorStorage = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager().getStorage();
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        Thread.sleep(1000L);
        this.scheduleLogCleanup(null, "1s", true, null, "ScriptTask", String.valueOf(processInstanceId), "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        System.out.println("Aborting process instance " + processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.scheduleLogCleanup(null, "5s", true, null, "ScriptTask", String.valueOf(processInstanceId), "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        this.scheduleLogCleanup(null, "0s", true, null, "ScriptTask", String.valueOf(processInstanceId), "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    @Test(timeout=30000L)
    public void testRunProcessWithAsyncHandlerDeleteUsingReoccurring() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = this.configureEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        ExecutionErrorStorage errorStorage = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager().getStorage();
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        this.scheduleLogCleanup(null, null, false, "3s", "ScriptTask", null, "yyyy-MM-dd HH:mm:ss", this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)errors.size());
        System.out.println("Process starting...");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        System.out.println("Process started...");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.reset(1);
        System.out.println("Waiting to generate an error...");
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        System.out.println("Aborting process instance " + processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    private ExecutorService buildExecutorService() {
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setInterval(1);
        this.executorService.setRetries(0);
        this.executorService.init();
        return this.executorService;
    }

    private void scheduleLogCleanup(Date olderThan, String olderThanPeriod, boolean singleRun, String nextRun, String forProcess, String forProcessInstance, String dateFormat, String identifier) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        commandContext.setData("SingleRun", (Object)Boolean.toString(singleRun));
        if (nextRun != null) {
            commandContext.setData("NextRun", (Object)nextRun);
        }
        if (olderThan != null) {
            commandContext.setData("OlderThan", (Object)new SimpleDateFormat(dateFormat).format(olderThan));
        }
        if (olderThanPeriod != null) {
            commandContext.setData("OlderThanPeriod", (Object)olderThanPeriod);
        }
        commandContext.setData("DateFormat", (Object)dateFormat);
        commandContext.setData("ForDeployment", (Object)identifier);
        commandContext.setData("ForProcess", (Object)forProcess);
        if (forProcessInstance != null) {
            commandContext.setData("ForProcessInstance", (Object)forProcessInstance);
        }
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ExecutionErrorCleanupCommand", commandContext);
    }

    private RuntimeEnvironment configureEnvironment() {
        return RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(CleanupExecutionErrorCommandWithProcessTest.this.executorService, "org.jbpm.executor.ThrowExceptionCommand"));
                return handlers;
            }
        }).get();
    }
}

