/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.h2.tools.Server;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class DBUnavilabilityExecutorTest {
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;
    private PoolingDataSourceWrapper pds;
    private static Server h2Server;

    @BeforeClass
    public static void createDBServer() throws Exception {
        h2Server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9123"});
        h2Server.start();
    }

    @AfterClass
    public static void stopDBServer() {
        if (h2Server.isRunning(false)) {
            h2Server.stop();
        }
    }

    @Before
    public void setUp() {
        Properties dsProps = ExecutorTestUtil.getDatasourceProperties();
        dsProps.setProperty("url", "jdbc:h2:tcp://localhost:9123/target/jbpm-exec-test;MVCC=TRUE");
        this.pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/jbpm-ds");
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setThreadPoolSize(1);
        this.executorService.setInterval(3);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=60000L)
    public void reoccurringExecutionTest() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(2);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        h2Server.stop();
        Thread.sleep(3000L);
        countDownListener.reset(2);
        h2Server.start();
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        this.executorService.cancelRequest(((RequestInfo)rescheduled.get(0)).getId());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)4L, (long)executedRequests.size());
    }
}

