/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorTestUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorTestUtil.class);
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    protected static final String MAX_POOL_SIZE = "maxPoolSize";
    protected static final String ALLOW_LOCAL_TXS = "allowLocalTransactions";
    protected static final String DATASOURCE_CLASS_NAME = "className";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String USER = "user";
    protected static final String PASSWORD = "password";
    protected static final String JDBC_URL = "url";

    public static PoolingDataSource setupPoolingDataSource() {
        Properties dsProps = ExecutorTestUtil.getDatasourceProperties();
        PoolingDataSource pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/jbpm-ds", (boolean)false);
        pds.init();
        return pds;
    }

    private static Properties getDatasourceProperties() {
        String password;
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = ExecutorTestUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty(PASSWORD)) || propertiesNotFound) {
            logger.warn("Unable to load datasource properties [/datasource.properties]");
        }
        ExecutorTestUtil.setDefaultProperties(props);
        return props;
    }

    private static void setDefaultProperties(Properties props) {
        String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", JDBC_URL, USER, PASSWORD, DRIVER_CLASS_NAME, DATASOURCE_CLASS_NAME, MAX_POOL_SIZE, ALLOW_LOCAL_TXS};
        String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:mem:jbpm-db;MVCC=true", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "5", "true"};
        Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
        for (int i = 0; i < keyArr.length; ++i) {
            if (props.containsKey(keyArr[i])) continue;
            props.put(keyArr[i], defaultPropArr[i]);
        }
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }
}

