/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorNotStartedException;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorAdminService;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;

public class ExecutorServiceImpl
implements org.kie.internal.executor.api.ExecutorService,
RequeueAware {
    private TimeUnit timeunit = TimeUnit.valueOf(System.getProperty("org.kie.executor.timeunit", "SECONDS"));
    private long maxRunningTime = Long.parseLong(System.getProperty("org.kie.executor.running.max", "600"));
    private Executor executor;
    private boolean executorStarted = false;
    private ExecutorQueryService queryService;
    private ExecutorAdminService adminService;
    private ExecutorEventSupport eventSupport = new ExecutorEventSupport();

    public ExecutorServiceImpl() {
    }

    public ExecutorServiceImpl(Executor executor) {
    }

    public ExecutorEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public void setEventSupport(ExecutorEventSupport eventSupport) {
        this.eventSupport = eventSupport;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public ExecutorQueryService getQueryService() {
        return this.queryService;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public ExecutorAdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(ExecutorAdminService adminService) {
        this.adminService = adminService;
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getFutureQueuedRequests();
    }

    public List<RequestInfo> getQueuedRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getQueuedRequests();
    }

    public List<RequestInfo> getCompletedRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getCompletedRequests();
    }

    public List<RequestInfo> getInErrorRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getInErrorRequests();
    }

    public List<RequestInfo> getCancelledRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getCancelledRequests();
    }

    public List<ErrorInfo> getAllErrors() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getAllErrors();
    }

    public List<RequestInfo> getAllRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getAllRequests();
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getRequestsByStatus(statuses);
    }

    public int clearAllRequests() {
        return this.adminService.clearAllRequests();
    }

    public int clearAllErrors() {
        return this.adminService.clearAllErrors();
    }

    public Long scheduleRequest(String commandName, CommandContext ctx) {
        return this.executor.scheduleRequest(commandName, ctx);
    }

    public void cancelRequest(Long requestId) {
        this.executor.cancelRequest(requestId);
    }

    public void init() {
        if (!this.executorStarted) {
            if (this.maxRunningTime > -1L) {
                this.requeue(this.maxRunningTime);
            }
            try {
                this.executor.init();
                this.executorStarted = true;
            }
            catch (ExecutorNotStartedException e) {
                this.executorStarted = false;
            }
        }
    }

    public void destroy() {
        if (this.executorStarted) {
            ExecutorServiceFactory.resetExecutorService((ExecutorService)this);
            this.executorStarted = false;
            this.executor.destroy();
        }
    }

    public boolean isActive() {
        return this.executorStarted;
    }

    public int getInterval() {
        return this.executor.getInterval();
    }

    public void setInterval(int waitTime) {
        this.executor.setInterval(waitTime);
    }

    public int getRetries() {
        return this.executor.getRetries();
    }

    public void setRetries(int defaultNroOfRetries) {
        this.executor.setRetries(defaultNroOfRetries);
    }

    public int getThreadPoolSize() {
        return this.executor.getThreadPoolSize();
    }

    public void setThreadPoolSize(int nroOfThreads) {
        this.executor.setThreadPoolSize(nroOfThreads);
    }

    public TimeUnit getTimeunit() {
        return this.executor.getTimeunit();
    }

    public void setTimeunit(TimeUnit timeunit) {
        this.executor.setTimeunit(timeunit);
    }

    public List<RequestInfo> getPendingRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getPendingRequests();
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        return this.queryService.getPendingRequestById(id);
    }

    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        return this.executor.scheduleRequest(commandId, date, ctx);
    }

    public List<RequestInfo> getRunningRequests() {
        return ((org.kie.internal.executor.api.ExecutorQueryService)this.queryService).getRunningRequests();
    }

    public RequestInfo getRequestById(Long requestId) {
        return this.queryService.getRequestById(requestId);
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        return this.queryService.getErrorsByRequestId(requestId);
    }

    public List<RequestInfo> getRequestsByBusinessKey(String businessKey, QueryContext queryContext) {
        return this.queryService.getRequestByBusinessKey(businessKey, queryContext);
    }

    public List<RequestInfo> getRequestsByCommand(String command, QueryContext queryContext) {
        return this.queryService.getRequestByCommand(command, queryContext);
    }

    @Override
    public void requeue(Long olderThan) {
        if (this.adminService instanceof RequeueAware) {
            if (olderThan == null) {
                olderThan = this.maxRunningTime;
            }
            ((RequeueAware)this.adminService).requeue(this.timeunit.convert(olderThan, TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void requeueById(Long requestId) {
        if (this.adminService instanceof RequeueAware) {
            ((RequeueAware)this.adminService).requeueById(requestId);
        }
    }

    public List<RequestInfo> getQueuedRequests(QueryContext queryContext) {
        return this.queryService.getQueuedRequests(queryContext);
    }

    public List<RequestInfo> getCompletedRequests(QueryContext queryContext) {
        return this.queryService.getCompletedRequests(queryContext);
    }

    public List<RequestInfo> getInErrorRequests(QueryContext queryContext) {
        return this.queryService.getInErrorRequests(queryContext);
    }

    public List<RequestInfo> getCancelledRequests(QueryContext queryContext) {
        return this.queryService.getCancelledRequests(queryContext);
    }

    public List<ErrorInfo> getAllErrors(QueryContext queryContext) {
        return this.queryService.getAllErrors(queryContext);
    }

    public List<RequestInfo> getAllRequests(QueryContext queryContext) {
        return this.queryService.getAllRequests(queryContext);
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByStatus(statuses, queryContext);
    }

    public List<RequestInfo> getPendingRequests(QueryContext queryContext) {
        return this.queryService.getPendingRequests(queryContext);
    }

    public List<RequestInfo> getRunningRequests(QueryContext queryContext) {
        return this.queryService.getRunningRequests(queryContext);
    }

    public List<RequestInfo> getFutureQueuedRequests(QueryContext queryContext) {
        return this.queryService.getFutureQueuedRequests(queryContext);
    }

    public void addAsyncJobListener(AsynchronousJobListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeAsyncJobListener(AsynchronousJobListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<AsynchronousJobListener> getAsyncJobListeners() {
        return this.eventSupport.getEventListeners();
    }

    public List<RequestInfo> getRequestsByBusinessKey(String businessKey, List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByBusinessKey(businessKey, statuses, queryContext);
    }

    public List<RequestInfo> getRequestsByCommand(String command, List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByCommand(command, statuses, queryContext);
    }

    public List<RequestInfo> getRequestsByDeployment(String deploymentId, List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByDeployment(deploymentId, statuses, queryContext);
    }

    public List<RequestInfo> getRequestsByProcessInstance(Long processInstanceId, List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByProcessInstance(processInstanceId, statuses, queryContext);
    }

    public void updateRequestData(Long requestId, Map<String, Object> data) {
        this.executor.updateRequestData(requestId, data);
    }
}

