/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(loadDirectory="target/test-classes")
public class LogCleanupCommandTest {
    private PoolingDataSourceWrapper pds;
    protected ExecutorService executorService;
    protected EntityManagerFactory emf = null;

    @Before
    public void setUp() {
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        this.executorService.setThreadPoolSize(1);
        this.executorService.setInterval(3);
    }

    @After
    public void tearDown() {
        this.executorService.clearAllErrors();
        this.executorService.clearAllRequests();
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/simulateSlowLogCleanupCommand.btm")
    public void logCleanupSingleRunTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("SingleRun", (Object)"true");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)0L, (long)rescheduled.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/simulateSlowLogCleanupCommand.btm")
    public void logCleanupNextRunIntervalTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("NextRun", (Object)"10s");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        this.executorService.cancelRequest(((RequestInfo)queuedRequests.get(0)).getId());
        long firstExecution = ((RequestInfo)executedRequests.get(0)).getTime().getTime();
        long nextExecution = ((RequestInfo)queuedRequests.get(0)).getTime().getTime();
        long diff = nextExecution - firstExecution;
        Assert.assertTrue((diff > 11000L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/simulateSlowLogCleanupCommand.btm")
    public void logCleanupNextRunFixedTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("NextRun", (Object)"10s");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        ctxCMD.setData("RepeatMode", (Object)"fixed");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        this.executorService.cancelRequest(((RequestInfo)queuedRequests.get(0)).getId());
        long firstExecution = ((RequestInfo)executedRequests.get(0)).getTime().getTime();
        long nextExecution = ((RequestInfo)queuedRequests.get(0)).getTime().getTime();
        long diff = nextExecution - firstExecution;
        Assert.assertTrue((diff < 11000L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/simulateSlowLogCleanupCommand.btm")
    public void logCleanupNextRunFixedIntervalTooSmallTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        System.setProperty("byteman.jpaaudit.sleep", "666");
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("NextRun", (Object)"1s");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        ctxCMD.setData("RepeatMode", (Object)"fixed");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        this.executorService.cancelRequest(((RequestInfo)queuedRequests.get(0)).getId());
        long firstExecution = ((RequestInfo)executedRequests.get(0)).getTime().getTime();
        long nextExecution = ((RequestInfo)queuedRequests.get(0)).getTime().getTime();
        long diff = nextExecution - firstExecution;
        Assert.assertTrue((diff >= 2000L && diff < 3000L ? 1 : 0) != 0);
        System.clearProperty("byteman.jpaaudit.sleep");
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/simulateSlowLogCleanupCommand.btm")
    public void logCleanupNextRunFixedPaginationTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        System.setProperty("byteman.jpaaudit.sleep", "666");
        System.setProperty("byteman.jpaaudit.delete", "1000");
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("NextRun", (Object)"10s");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        ctxCMD.setData("RepeatMode", (Object)"fixed");
        ctxCMD.setData("RecordsPerTransaction", (Object)500);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        System.clearProperty("byteman.jpaaudit.delete");
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)2L, (long)executedRequests.size());
        this.executorService.cancelRequest(((RequestInfo)queuedRequests.get(0)).getId());
        long firstExecution = ((RequestInfo)executedRequests.get(0)).getTime().getTime();
        long lastExecution = ((RequestInfo)queuedRequests.get(queuedRequests.size() - 1)).getTime().getTime();
        long diff = lastExecution - firstExecution;
        Assert.assertTrue((diff < 11000L ? 1 : 0) != 0);
        System.clearProperty("byteman.jpaaudit.sleep");
    }
}

