/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.query.AbstractAuditDeleteBuilderImpl;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;

public class ErrorInfoDeleteBuilderImpl
extends AbstractAuditDeleteBuilderImpl<ErrorInfoDeleteBuilder>
implements ErrorInfoDeleteBuilder {
    private static final String ERROR_INFO_LOG_DELETE = "ErrorInfo";

    public ErrorInfoDeleteBuilderImpl(CommandExecutor cmdExecutor) {
        super(cmdExecutor);
        this.intersect();
    }

    public ErrorInfoDeleteBuilderImpl(JPAAuditLogService jpaAuditService) {
        super(jpaAuditService);
        this.intersect();
    }

    public ErrorInfoDeleteBuilder date(Date ... date) {
        if (this.checkIfNull(date)) {
            return this;
        }
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "date", this.ensureDateNotTimestamp(date));
        return this;
    }

    public ErrorInfoDeleteBuilder dateRangeStart(Date rangeStart) {
        if (this.checkIfNull(new Date[]{rangeStart})) {
            return this;
        }
        this.addRangeParameter(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "date range end", this.ensureDateNotTimestamp(new Date[]{rangeStart})[0], true);
        return this;
    }

    public ErrorInfoDeleteBuilder dateRangeEnd(Date rangeStart) {
        if (this.checkIfNull(new Date[]{rangeStart})) {
            return this;
        }
        this.addRangeParameter(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "date range end", this.ensureDateNotTimestamp(new Date[]{rangeStart})[0], false);
        return this;
    }

    protected Class getQueryType() {
        return ErrorInfo.class;
    }

    protected String getQueryTable() {
        return ERROR_INFO_LOG_DELETE;
    }

    protected boolean isSubquerySupported() {
        return true;
    }

    protected AbstractAuditDeleteBuilderImpl.Subquery applyParameters(AbstractAuditDeleteBuilderImpl.Subquery subquery) {
        return subquery;
    }

    protected AbstractAuditDeleteBuilderImpl.Subquery getSubQuery() {
        String queryBaseStr = "SELECT r.id from RequestInfo r where r.status in ('ERROR', 'CANCELLED', 'DONE') AND (r.processInstanceId is null OR r.processInstanceId not in (SELECT spl.processInstanceId FROM ProcessInstanceLog spl where spl.status in (0,1,4)))";
        return new AbstractAuditDeleteBuilderImpl.Subquery("l.requestInfo", queryBaseStr, 1);
    }
}

