/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.util.List;
import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.CompositeNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.kie.definition.process.Connection;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ForEachNodeHandler
extends CompositeNodeHandler {
    @Override
    protected Node createNode() {
        return new ForEachNode();
    }

    public Class generateNodeFor() {
        return ForEachNode.class;
    }

    @Override
    protected String getNodeName() {
        return "forEach";
    }

    @Override
    protected void writeAttributes(CompositeNode compositeNode, StringBuilder xmlDump, boolean includeMeta) {
        boolean waitForCompletion;
        String collectionExpression;
        ForEachNode forEachNode = (ForEachNode)compositeNode;
        String variableName = forEachNode.getVariableName();
        if (variableName != null) {
            xmlDump.append("variableName=\"" + variableName + "\" ");
        }
        if ((collectionExpression = forEachNode.getCollectionExpression()) != null) {
            xmlDump.append("collectionExpression=\"" + XmlDumper.replaceIllegalChars((String)collectionExpression) + "\" ");
        }
        if (!(waitForCompletion = forEachNode.isWaitForCompletion())) {
            xmlDump.append("waitForCompletion=\"false\" ");
        }
    }

    @Override
    protected List<Node> getSubNodes(CompositeNode compositeNode) {
        return super.getSubNodes((CompositeNode)((ForEachNode)compositeNode).getCompositeNode());
    }

    @Override
    protected List<Connection> getSubConnections(CompositeNode compositeNode) {
        return super.getSubConnections((CompositeNode)((ForEachNode)compositeNode).getCompositeNode());
    }

    @Override
    protected Map<String, CompositeNode.NodeAndType> getInPorts(CompositeNode compositeNode) {
        return ((ForEachNode)compositeNode).getCompositeNode().getLinkedIncomingNodes();
    }

    @Override
    protected Map<String, CompositeNode.NodeAndType> getOutPorts(CompositeNode compositeNode) {
        return ((ForEachNode)compositeNode).getCompositeNode().getLinkedOutgoingNodes();
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String waitForCompletion;
        String collectionExpression;
        super.handleNode(node, element, uri, localName, parser);
        ForEachNode forEachNode = (ForEachNode)node;
        String variableName = element.getAttribute("variableName");
        if (variableName != null && variableName.length() != 0) {
            forEachNode.setVariable(variableName, (DataType)new ObjectDataType());
        }
        if ((collectionExpression = element.getAttribute("collectionExpression")) != null && collectionExpression.length() != 0) {
            forEachNode.setCollectionExpression(collectionExpression);
        }
        if ("false".equals(waitForCompletion = element.getAttribute("waitForCompletion"))) {
            forEachNode.setWaitForCompletion(false);
        }
    }
}

