/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.util.List;
import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;

public class StartNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        StartNode startNode = (StartNode)node;
        this.writeNode("start", (Node)startNode, xmlDump, includeMeta);
        List triggers = startNode.getTriggers();
        if (!(triggers != null && !triggers.isEmpty() || includeMeta && this.containsMetaData((Node)startNode))) {
            this.endNode(xmlDump);
        } else {
            xmlDump.append(">" + EOL);
            if (includeMeta) {
                this.writeMetaData((Node)startNode, xmlDump);
            }
            if (triggers != null) {
                xmlDump.append("      <triggers>" + EOL);
                for (Trigger trigger : triggers) {
                    Map inMappings;
                    if (trigger instanceof ConstraintTrigger) {
                        xmlDump.append("        <trigger type=\"constraint\" >" + EOL);
                        xmlDump.append("          <constraint type=\"rule\" dialect=\"mvel\" >" + ((ConstraintTrigger)trigger).getConstraint() + "</constraint>" + EOL);
                        inMappings = trigger.getInMappings();
                        if (inMappings != null && !inMappings.isEmpty()) {
                            for (Map.Entry entry : inMappings.entrySet()) {
                                xmlDump.append("          <mapping type=\"in\" from=\"" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "\" to=\"" + (String)entry.getKey() + "\" />" + EOL);
                            }
                        }
                        xmlDump.append("        </trigger>" + EOL);
                        continue;
                    }
                    if (trigger instanceof EventTrigger) {
                        xmlDump.append("        <trigger type=\"event\" >" + EOL);
                        xmlDump.append("          <eventFilters>" + EOL);
                        for (EventFilter filter : ((EventTrigger)trigger).getEventFilters()) {
                            if (filter instanceof EventTypeFilter) {
                                xmlDump.append("             <eventFilter type=\"eventType\" eventType=\"" + ((EventTypeFilter)filter).getType() + "\" />" + EOL);
                                continue;
                            }
                            throw new IllegalArgumentException("Unknown filter type: " + filter);
                        }
                        xmlDump.append("          </eventFilters>" + EOL);
                        inMappings = trigger.getInMappings();
                        if (inMappings != null && !inMappings.isEmpty()) {
                            for (Map.Entry entry : inMappings.entrySet()) {
                                xmlDump.append("          <mapping type=\"in\" from=\"" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "\" to=\"" + (String)entry.getKey() + "\" />" + EOL);
                            }
                        }
                        xmlDump.append("        </trigger>" + EOL);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown trigger type " + trigger);
                }
                xmlDump.append("      </triggers>" + EOL);
            }
            this.endNode("start", xmlDump);
        }
    }
}

