/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.jbpm.process.builder.dialect.mvel.MVELActionBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.MVELAction;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MVELDecisionBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleAction() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( 'hello world' )");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        PackageRegistry pkgReg = pkgBuilder.getPackageRegistry(pkg.getName());
        MVELDialect mvelDialect = (MVELDialect)pkgReg.getDialectCompiletimeRegistry().getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init(pkgBuilder, (InternalKnowledgePackage)pkg, null, pkgReg.getDialectCompiletimeRegistry(), (Dialect)mvelDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        actionNode.setAction((DroolsAction)action);
        MVELActionBuilder builder = new MVELActionBuilder();
        builder.build(context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Arrays.asList(pkgBuilder.getPackage()));
        StatefulKnowledgeSession wm = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkgBuilder.getPackage().getDialectRuntimeRegistry().getDialectData("mvel");
        org.drools.core.spi.ProcessContext processContext = new org.drools.core.spi.ProcessContext((KieRuntime)((InternalWorkingMemory)wm).getKnowledgeRuntime());
        ((MVELAction)actionNode.getAction().getMetaData("Action")).compile(data);
        ((Action)actionNode.getAction().getMetaData("Action")).execute((ProcessContext)processContext);
        Assert.assertEquals((Object)"hello world", list.get(0));
    }
}

