/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.io.impl.ReaderResource;
import org.jbpm.integrationtests.TestVariable;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Message;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProcessActionTest
extends AbstractBaseTest {
    @Test
    public void testOnEntryExit() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <onEntry>\n        <action type=\"expression\" name=\"Print\" dialect=\"mvel\" >list.add(\"Executing on entry action\");</action>\n      </onEntry>\n      <onExit>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action1\");</action>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action2\");</action>\n      </onExit>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testActionContextJava() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nString myVariable = (String) kcontext.getVariable(\"variable\");\nlist.add(myVariable);\nString nodeName = kcontext.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"SomeText", list.get(0));
        Assert.assertEquals((Object)"MyActionNode", list.get(1));
        Collection factHandles = ksession.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof Message;
            }
        });
        Assert.assertFalse((boolean)factHandles.isEmpty());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testActionContextMVEL() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\nSystem.out.println(kcontext.getKnowledgeRuntime());\nString myVariable = (String) kcontext.getVariable(\"variable\");\nlist.add(myVariable);\nString nodeName = kcontext.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"SomeText", list.get(0));
        Assert.assertEquals((Object)"MyActionNode", list.get(1));
        Collection factHandles = ksession.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof Message;
            }
        });
        Assert.assertFalse((boolean)factHandles.isEmpty());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testActionVariableJava() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.TestVariable\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.TestVariable\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nlist.add(person.getName());\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        TestVariable person = new TestVariable("John Doe");
        HashMap<String, TestVariable> params = new HashMap<String, TestVariable>();
        params.put("person", person);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions", params);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John Doe", list.get(0));
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testActionVariableMVEL() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.TestVariable\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.TestVariable\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\nlist.add(person.name);\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        TestVariable person = new TestVariable("John Doe");
        HashMap<String, TestVariable> params = new HashMap<String, TestVariable>();
        params.put("person", person);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions", params);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John Doe", list.get(0));
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testActionNameConflict() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions1\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"Action1\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions2\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"Action2\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions1");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Action1", list.get(0));
        list.clear();
        processInstance = ksession.startProcess("org.drools.actions2");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Action2", list.get(0));
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }
}

