/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.compiler.DroolsError;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.integrationtests.test.Message;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTimerTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTimerTest.class);

    @Test
    public void testSimpleProcess() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"2\" name=\"End\" />\n    <timerNode id=\"3\" name=\"Timer\" delay=\"800ms\" period=\"200ms\" />\n    <actionNode id=\"4\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nmyList.add( new Message() );\ninsert( new Message() );\n</action>\n    </actionNode>\n    <milestone id=\"5\" name=\"Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Number( intValue &gt;= 5 ) from accumulate ( m: Message( ), count( m ) )</constraint>\n    </milestone>\n  </nodes>\n\n  <connections>\n    <connection from=\"5\" to=\"2\" />\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        if (!this.builder.getErrors().isEmpty()) {
            for (DroolsError error : this.builder.getErrors().getErrors()) {
                logger.error(error.toString());
            }
            Assert.fail((String)"Could not build process");
        }
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)myList.size());
        try {
            Thread.sleep(1300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)myList.size());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        session.dispose();
    }

    @Test
    public void testVariableSimpleProcess() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n      <variable name=\"y\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"2\" name=\"End\" />\n    <timerNode id=\"3\" name=\"Timer\" delay=\"#{x}ms\" period=\"#{y}ms\" />\n    <actionNode id=\"4\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nmyList.add( new Message() );\ninsert( new Message() );\n</action>\n    </actionNode>\n    <milestone id=\"5\" name=\"Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Number( intValue &gt;= 5 ) from accumulate ( m: Message( ), count( m ) )</constraint>\n    </milestone>\n  </nodes>\n\n  <connections>\n    <connection from=\"5\" to=\"2\" />\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        if (!this.builder.getErrors().isEmpty()) {
            for (DroolsError error : this.builder.getErrors().getErrors()) {
                logger.error(error.toString());
            }
            Assert.fail((String)"Could not build process");
        }
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 800);
        params.put("y", 200);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer", params);
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)myList.size());
        try {
            Thread.sleep(1300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)myList.size());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        session.dispose();
    }

    @Test
    public void testIncorrectTimerNode() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"2\" name=\"End\" />\n    <timerNode id=\"3\" name=\"Timer\" delay=\"800msdss\" period=\"200mssds\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"3\" to=\"2\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        Assert.assertEquals((long)2L, (long)this.builder.getErrors().size());
        for (DroolsError error : this.builder.getErrors().getErrors()) {
            logger.error(error.toString());
        }
    }

    @Test
    public void testOnEntryTimerExecuted() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)myList.size());
        session.dispose();
    }

    @Test
    public void testOnEntryTimerVariableExecuted() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"#{x}\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        final StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        new Thread(new Runnable(){

            @Override
            public void run() {
                session.fireUntilHalt();
            }
        }).start();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 300);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer", params);
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)myList.size());
        session.dispose();
    }

    @Test
    public void testOnEntryTimerWorkItemExecuted() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Work\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)myList.size());
        session.dispose();
    }

    @Test
    public void testIncorrectOnEntryTimer() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"300asdf\" period=\"asfd\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        Assert.assertEquals((long)2L, (long)this.builder.getErrors().size());
        for (DroolsError error : this.builder.getErrors().getErrors()) {
            logger.error(error.toString());
        }
    }

    @Test
    public void testOnEntryTimerExecutedMultipleTimes() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" period =\"200\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        session.halt();
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)myList.size());
        session.dispose();
    }

    @Test
    public void testMultipleTimers() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"600\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer1\");</action>\n        </timer>\n        <timer id=\"2\" delay=\"200\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer2\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        InternalKnowledgePackage pkg = this.builder.getPackage();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Arrays.asList(this.builder.getPackages()));
        SessionConfiguration conf = SessionConfiguration.newInstance();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession((KieSessionConfiguration)conf, null);
        SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        clock = (SessionPseudoClock)session.getSessionClock();
        clock.advanceTime(500L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)myList.size());
        Assert.assertEquals((Object)"Executing timer2", myList.get(0));
        clock.advanceTime(500L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)myList.size());
        session.dispose();
    }

    @Test
    public void testOnEntryTimerCancelled() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"2000\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >org.jbpm.integrationtests.test.Message( )</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        StatefulKnowledgeSession session = this.createKieSession(new KnowledgePackage[]{this.builder.getPackage()});
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.drools.timer");
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        session.insert((Object)new Message());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertEquals((long)0L, (long)((InternalProcessRuntime)((InternalWorkingMemory)session).getProcessRuntime()).getTimerManager().getTimers().size());
        session.dispose();
    }
}

