/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.api.KieBase;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmSerializationHelper
extends SerializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(JbpmSerializationHelper.class);

    public static <T> T serializeObject(T obj) throws IOException, ClassNotFoundException {
        return JbpmSerializationHelper.serializeObject(obj, null);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(KieSession ksession) throws Exception {
        return SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
    }

    public static <T> T serializeObject(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return (T)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut(obj), (ClassLoader)classLoader);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(StatefulKnowledgeSession ksession, boolean dispose) throws Exception {
        return JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, MarshallerFactory.newSerializeMarshallingStrategy(), dispose);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(StatefulKnowledgeSession ksession, ObjectMarshallingStrategy strategy, boolean dispose) throws Exception {
        ObjectMarshallingStrategy[] strategies = new ObjectMarshallingStrategy[]{strategy};
        return JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, strategies, dispose);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(StatefulKnowledgeSession ksession, ObjectMarshallingStrategy[] strategies, boolean dispose) throws Exception {
        StatefulKnowledgeSession ksession2;
        byte[] b2;
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)ksession.getKieBase(), (ObjectMarshallingStrategy[])strategies);
        byte[] b1 = JbpmSerializationHelper.serializeKnowledgeSession(marshaller, ksession);
        if (!JbpmSerializationHelper.areByteArraysEqual(b1, b2 = JbpmSerializationHelper.serializeKnowledgeSession(marshaller, ksession2 = JbpmSerializationHelper.deserializeKnowledgeSession(marshaller, b1)))) {
            // empty if block
        }
        ((StatefulKnowledgeSessionImpl)ksession2).setGlobalResolver(((StatefulKnowledgeSessionImpl)ksession).getGlobalResolver());
        if (dispose) {
            ksession.dispose();
        }
        return ksession2;
    }

    public static byte[] serializeKnowledgeSession(Marshaller marshaller, StatefulKnowledgeSession ksession) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)bos, (KieSession)ksession);
        byte[] ksessionBytes = bos.toByteArray();
        bos.close();
        return ksessionBytes;
    }

    public static StatefulKnowledgeSession deserializeKnowledgeSession(Marshaller marshaller, byte[] serializedKsession) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedKsession);
        StatefulKnowledgeSession deserializedKsession = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)bais, (KieSessionConfiguration)SessionConfiguration.newInstance(), EnvironmentFactory.newEnvironment());
        bais.close();
        return deserializedKsession;
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            logger.info("Different length: b1={} b2={}", (Object)b1.length, (Object)b2.length);
            return false;
        }
        int length = b1.length;
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            logger.info("Difference at {} : [{}] != [{}]", new Object[]{i, b1[i], b2[i]});
            return false;
        }
        return true;
    }
}

