/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.compiler.compiler.DroolsError;
import org.jbpm.integrationtests.JbpmSerializationHelper;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMultiThreadTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMultiThreadTest.class);

    @Test
    public void testMultiThreadProcessInstanceSignalling() {
        int THREAD_COUNT = 2;
        try {
            int i;
            boolean success = true;
            Thread[] t = new Thread[2];
            this.builder.addProcessFromXml((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ProcessMultithreadEvent.rf")));
            if (this.builder.getErrors().getErrors().length > 0) {
                for (DroolsError error : this.builder.getErrors().getErrors()) {
                    logger.error(error.toString());
                }
                Assert.fail((String)"Could not parse process");
            }
            StatefulKnowledgeSession session = this.createKieSession(true, new KnowledgePackage[]{this.builder.getPackage()});
            session = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session);
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            ProcessInstance processInstance = session.startProcess("org.drools.integrationtests.multithread");
            ProcessInstanceSignalRunner[] r = new ProcessInstanceSignalRunner[2];
            for (i = 0; i < t.length; ++i) {
                r[i] = new ProcessInstanceSignalRunner(i, processInstance, "event" + (i + 1));
                t[i] = new Thread((Runnable)r[i], "thread-" + i);
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join();
                if (r[i].getStatus() != ProcessInstanceSignalRunner.Status.FAIL) continue;
                success = false;
            }
            if (!success) {
                Assert.fail((String)"Multithread test failed. Look at the stack traces for details. ");
            }
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertFalse((boolean)((String)list.get(0)).equals(list.get(1)));
            Assert.assertEquals((long)2L, (long)processInstance.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    public static class ProcessInstanceSignalRunner
    implements Runnable {
        private ProcessInstance processInstance;
        private String type;
        private Status status;
        private int id;

        public ProcessInstanceSignalRunner(int id, ProcessInstance processInstance, String type) {
            this.id = id;
            this.processInstance = processInstance;
            this.type = type;
            this.status = Status.SUCCESS;
        }

        @Override
        public void run() {
            try {
                this.processInstance.signalEvent(this.type, null);
            }
            catch (Exception e) {
                this.status = Status.FAIL;
                logger.warn("{} failed: {}", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
            }
        }

        public int getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }

        public static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

