/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;

public class ProcessHumanTaskTest
extends AbstractBaseTest {
    @Test
    public void testHumanTask() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)workingMemory.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testSwimlane() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <swimlanes>\n      <swimlane name=\"actor1\" />\n    </swimlanes>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"out\" from=\"ActorId\" to=\"ActorId\" />    </humanTask>\n    <humanTask id=\"3\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something else</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"out\" from=\"ActorId\" to=\"ActorId\" />    </humanTask>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)workingMemory.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"Do something", (Object)workItem.getParameter("TaskName"));
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "Jane Doe");
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"Do something else", (Object)workItem.getParameter("TaskName"));
        Assert.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("SwimlaneActorId"));
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testHumanTaskCancel() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)workingMemory.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        processInstance.setState(3);
        Assert.assertTrue((boolean)handler.isAborted());
    }

    @Test
    public void testHumanTaskCancel2() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <onExit>\n        <action type=\"expression\" name=\"Cancel\" dialect=\"java\" >((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();</action>\n      </onExit>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)workingMemory.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assert.assertFalse((boolean)handler.isAborted());
    }
}

