/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.drools.compiler.compiler.DroolsError;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMilestoneTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMilestoneTest.class);

    @Test
    public void testMilestone() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.milestone\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Milestone\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( name == \"John Doe\" )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ProcessInstance processInstance = (ProcessInstance)workingMemory.startProcess("org.drools.milestone");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        workingMemory.insert((Object)new Person("Jane Doe", 20));
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        workingMemory.insert((Object)new Person("John Doe", 50));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testMilestoneWithProcessInstanceConstraint() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.milestone\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n      <import name=\"org.jbpm.integrationtests.ProcessMilestoneTest.ProcessUtils\" />\n    </imports>\n    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Milestone\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >processInstance: org.jbpm.ruleflow.instance.RuleFlowProcessInstance()\nPerson( name == (ProcessUtils.getValue(processInstance, \"name\")) )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        for (DroolsError error : this.builder.getErrors().getErrors()) {
            logger.error(error.toString());
        }
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        ProcessInstance processInstanceJohn = (ProcessInstance)workingMemory.startProcess("org.drools.milestone", params);
        workingMemory.insert((Object)processInstanceJohn);
        Assert.assertEquals((long)1L, (long)processInstanceJohn.getState());
        params = new HashMap();
        params.put("name", jane.getName());
        ProcessInstance processInstanceJane = (ProcessInstance)workingMemory.startProcess("org.drools.milestone", params);
        workingMemory.insert((Object)processInstanceJane);
        Assert.assertEquals((long)1L, (long)processInstanceJane.getState());
        workingMemory.insert((Object)jane);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)processInstanceJohn.getState());
        Assert.assertEquals((long)2L, (long)processInstanceJane.getState());
        workingMemory.insert((Object)john);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstanceJohn.getState());
    }

    public static class ProcessUtils {
        public static Object getValue(RuleFlowProcessInstance processInstance, String name) {
            VariableScopeInstance scope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            return scope.getVariable(name);
        }
    }
}

