/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessSubProcessTest
extends AbstractBaseTest {
    @Test
    public void testSubProcess() throws Exception {
        KieSession workingMemory = ProcessSubProcessTest.createStatefulKnowledgeSessionFromRule(true);
        ProcessInstance processInstance = workingMemory.startProcess("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)workingMemory.getProcessInstances().size());
        workingMemory.insert((Object)new Person());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)0L, (long)workingMemory.getProcessInstances().size());
    }

    @Test
    public void testSubProcessCancel() throws Exception {
        KieSession workingMemory = ProcessSubProcessTest.createStatefulKnowledgeSessionFromRule(true);
        org.jbpm.process.instance.ProcessInstance processInstance = (org.jbpm.process.instance.ProcessInstance)workingMemory.startProcess("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)workingMemory.getProcessInstances().size());
        processInstance.setState(3);
        Assert.assertEquals((long)1L, (long)workingMemory.getProcessInstances().size());
    }

    @Test
    public void testIndependentSubProcessCancel() throws Exception {
        KieSession workingMemory = ProcessSubProcessTest.createStatefulKnowledgeSessionFromRule(false);
        org.jbpm.process.instance.ProcessInstance processInstance = (org.jbpm.process.instance.ProcessInstance)workingMemory.startProcess("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)workingMemory.getProcessInstances().size());
        processInstance.setState(3);
        Assert.assertEquals((long)0L, (long)workingMemory.getProcessInstances().size());
    }

    @Test
    public void testVariableMapping() throws Exception {
        KieSession workingMemory = ProcessSubProcessTest.createStatefulKnowledgeSessionFromRule(true);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", "x-value");
        org.jbpm.process.instance.ProcessInstance processInstance = (org.jbpm.process.instance.ProcessInstance)workingMemory.startProcess("com.sample.ruleflow", map);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)workingMemory.getProcessInstances().size());
        for (ProcessInstance p : workingMemory.getProcessInstances()) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)p).getContextInstance("VariableScope");
            if ("com.sample.ruleflow".equals(p.getProcessId())) {
                Assert.assertEquals((Object)"x-value", (Object)variableScopeInstance.getVariable("x"));
                continue;
            }
            if (!"com.sample.subflow".equals(p.getProcessId())) continue;
            Assert.assertEquals((Object)"x-value", (Object)variableScopeInstance.getVariable("y"));
            Assert.assertEquals((Object)"z-value", (Object)variableScopeInstance.getVariable("z"));
            Assert.assertEquals((Object)7, (Object)variableScopeInstance.getVariable("n"));
            Assert.assertEquals((Object)10, (Object)variableScopeInstance.getVariable("o"));
        }
        workingMemory.insert((Object)new Person());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        Assert.assertEquals((Object)"z-value", (Object)variableScopeInstance.getVariable("x"));
        Assert.assertEquals((Object)10, (Object)variableScopeInstance.getVariable("m"));
        Assert.assertEquals((long)0L, (long)workingMemory.getProcessInstances().size());
    }

    private static KieSession createStatefulKnowledgeSessionFromRule(boolean independentSubProcess) throws Exception {
        KieBase ruleBase = ProcessSubProcessTest.readRule(independentSubProcess);
        return ruleBase.newKieSession();
    }

    private static KieBase readRule(boolean independent) throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n  <header>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value></value>\n      </variable>\n      <variable name=\"m\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.IntegerDataType\" />\n        <value></value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <subProcess id=\"2\" name=\"SubProcess\" processId=\"com.sample.subflow\" independent=\"" + independent + "\" >\n      <mapping type=\"in\" from=\"x\" to=\"y\" />\n      <mapping type=\"in\" from=\"x.length()\" to=\"n\" />\n      <mapping type=\"out\" from=\"z\" to=\"x\" />\n      <mapping type=\"out\" from=\"o\" to=\"m\" />\n    </subProcess>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"com.sample.subflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <variables>\n      <variable name=\"y\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value></value>\n      </variable>\n      <variable name=\"z\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>z-value</value>\n      </variable>\n      <variable name=\"n\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n      <variable name=\"o\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.IntegerDataType\" />\n        <value>10</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(builder.getPackage()));
        return kbase;
    }

    @Test
    public void testDynamicSubProcess() throws Exception {
        KieBase kbase = ProcessSubProcessTest.readDynamicSubProcess();
        KieSession workingMemory = kbase.newKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "subflow");
        ProcessInstance processInstance = workingMemory.startProcess("com.sample.ruleflow", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)2L, (long)workingMemory.getProcessInstances().size());
        workingMemory.insert((Object)new Person());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)0L, (long)workingMemory.getProcessInstances().size());
    }

    private static KieBase readDynamicSubProcess() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n  <header>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value></value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <subProcess id=\"2\" name=\"SubProcess\" processId=\"com.sample.#{x}\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"com.sample.subflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(builder.getPackage()));
        return kbase;
    }
}

