/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.compiler.compiler.DroolsError;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDynamicNodeTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDynamicNodeTest.class);

    @Test
    @Ignore
    public void TODOtestDynamicActions() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <actionNode id=\"1\" name=\"Action1\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action1\");\nlist.add(\"Action1\");</action>\n        </actionNode>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        this.builder.addRuleFlow((Reader)source);
        InternalKnowledgePackage pkg = this.builder.getPackage();
        for (DroolsError error : this.builder.getErrors().getErrors()) {
            logger.error(error.toString());
        }
        KieSession ksession = this.createKieSession(new KiePackage[]{pkg});
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = (ProcessInstance)ksession.startProcess("org.drools.dynamic");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    @Ignore
    public void TODOtestDynamicAsyncActions() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <workItem id=\"1\" name=\"Work\" >\n          <work name=\"Work\" />\n        </workItem>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        this.builder.addRuleFlow((Reader)source);
        InternalKnowledgePackage pkg = this.builder.getPackage();
        for (DroolsError error : this.builder.getErrors().getErrors()) {
            logger.error(error.toString());
        }
        KieSession ksession = this.createKieSession(new KiePackage[]{pkg});
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Work", (WorkItemHandler)testHandler);
        ProcessInstance processInstance = (ProcessInstance)ksession.startProcess("org.drools.dynamic");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = testHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testAddDynamicWorkItem() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <actionNode id=\"1\" name=\"Action\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n</process>");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KieBase kbase = kbuilder.newKieBase();
        KieSession ksession = kbase.newKieSession();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"test");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)ksession.startProcess("org.drools.dynamic");
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("TaskName", "Dynamic Task");
        Assert.assertNull((Object)handler.getWorkItem());
        Assert.assertEquals((long)0L, (long)dynamicContext.getNodeInstances().size());
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicContext, (KieRuntime)ksession, (String)"Human Task", parameters);
        Assert.assertNotNull((Object)handler.getWorkItem());
        Assert.assertEquals((long)1L, (long)dynamicContext.getNodeInstances().size());
        logger.close();
    }

    @Test
    public void testAddDynamicSubProcess() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <actionNode id=\"1\" name=\"Action\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n</process>");
        StringReader source2 = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"subflow\" id=\"org.drools.subflow\" package-name=\"org.drools\" >\n\n  <header>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(x);</action>\n    </actionNode>\n    <workItem id=\"3\" name=\"Work\" >\n      <work name=\"Human Task\" />\n    </workItem>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source2), ResourceType.DRF);
        KieBase kbase = kbuilder.newKieBase();
        KieSession ksession = kbase.newKieSession();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"test");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)ksession.startProcess("org.drools.dynamic");
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "NewValue");
        Assert.assertNull((Object)handler.getWorkItem());
        Assert.assertEquals((long)0L, (long)dynamicContext.getNodeInstances().size());
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)ksession, (String)"org.drools.subflow", parameters);
        Assert.assertNotNull((Object)handler.getWorkItem());
        Assert.assertEquals((long)1L, (long)dynamicContext.getNodeInstances().size());
        logger.close();
    }
}

