/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;

public class ProcessRuleFlowGroupTest
extends AbstractBaseTest {
    @Test
    public void testRuleSetProcessContext() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.ruleset\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"RuleSet\" ruleFlowGroup=\"MyGroup\" >\n    </ruleSet>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        StringReader source2 = new StringReader("package org.jbpm;\n\nimport org.jbpm.integrationtests.test.Person;\nimport org.kie.api.runtime.process.ProcessContext;\n\nrule MyRule ruleflow-group \"MyGroup\" dialect \"mvel\" \n  when\n    Person( age > 25 )\n  then\n    System.out.println(drools.getContext(ProcessContext).getProcessInstance().getProcessName());\nend");
        this.builder.addRuleFlow((Reader)source);
        this.builder.addPackageFromDrl((Reader)source2);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        workingMemory.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)"true");
        Person person = new Person();
        person.setAge(30);
        workingMemory.insert((Object)person);
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)workingMemory.startProcess("org.drools.ruleset");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }
}

