/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSplitTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessSplitTest.class);

    @Test
    public void testSplitWithProcessInstanceConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" priority=\"2\" type=\"rule\" dialect=\"mvel\" >eval(true)</constraint>        <constraint toNodeId=\"6\" name=\"constraint\" priority=\"1\" type=\"rule\" dialect=\"mvel\" >processInstance: org.jbpm.ruleflow.instance.RuleFlowProcessInstance()Person( name == (ProcessUtils.getValue(processInstance, \"name\")) )</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        Person julie = new Person("Julie Doe", 20);
        workingMemory.insert((Object)john);
        workingMemory.insert((Object)jane);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        ProcessInstance processInstance1 = workingMemory.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", jane.getName());
        ProcessInstance processInstance2 = workingMemory.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", julie.getName());
        ProcessInstance processInstance3 = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance1.getState());
        Assert.assertEquals((long)2L, (long)processInstance2.getState());
        Assert.assertEquals((long)2L, (long)processInstance3.getState());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testSplitWithProcessInstanceConstraint2() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.kie.api.runtime.process.WorkflowProcessInstance\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"rule\" dialect=\"mvel\" >eval(true)</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" name=\"constraint\" priority=\"1\" type=\"rule\" dialect=\"mvel\" >processInstance: WorkflowProcessInstance()Person( name == ( processInstance.getVariable(\"name\") ) )</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        for (KnowledgeBuilderError error : kbuilder.getErrors()) {
            logger.error(error.toString());
        }
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        Person julie = new Person("Julie Doe", 20);
        ksession.insert((Object)john);
        ksession.insert((Object)jane);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        ProcessInstance processInstance1 = ksession.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", jane.getName());
        ProcessInstance processInstance2 = ksession.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", julie.getName());
        ProcessInstance processInstance3 = ksession.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance1.getState());
        Assert.assertEquals((long)2L, (long)processInstance2.getState());
        Assert.assertEquals((long)2L, (long)processInstance3.getState());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testSplitWithMVELContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return kcontext.getVariable(\"person\") != null &amp;&amp; ((Person) kcontext.getVariable(\"person\")).name != null;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("John Doe"));
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithJavaContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(context.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return context.getVariable(\"name\") != null &amp;&amp; ((String) context.getVariable(\"name\")).length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(context.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithMVELkContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return context.getVariable(\"person\") != null &amp;&amp; ((org.jbpm.integrationtests.test.Person) context.getVariable(\"person\")).name != null;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("John Doe"));
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithJavakContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return kcontext.getVariable(\"name\") != null &amp;&amp; ((String) kcontext.getVariable(\"name\")).length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithMVELVariableConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(context.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return name != null &amp;&amp; name.length > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(context.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithJavaVariableConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(context.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return name != null &amp;&amp; name.length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(context.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithMVELGlobalConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(context.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return list != null &amp;&amp; list.size() >= 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(context.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSplitWithJavaGlobalConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(context.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return list != null &amp;&amp; list.size() >= 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(context.getProcessInstance().getId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.addRuleFlow((Reader)source);
        KieSession workingMemory = this.createKieSession(new KiePackage[]{this.builder.getPackage()});
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ProcessInstance processInstance = workingMemory.startProcess("org.jbpm.process-split");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    public static class ProcessUtils {
        public static Object getValue(RuleFlowProcessInstance processInstance, String name) {
            VariableScopeInstance scope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            return scope.getVariable(name);
        }
    }
}

