/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEventListenerTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessEventListenerTest.class);
    private static final String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"MyVar\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n      <eventFilters>\n        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n      </eventFilters>\n    </eventNode>\n    <actionNode id=\"3\" name=\"Signal Event\" >\n      <action type=\"expression\" dialect=\"java\" >context.getProcessInstance().signalEvent(\"MyEvent\", \"MyValue\");</action>\n    </actionNode>\n    <join id=\"4\" name=\"Join\" type=\"1\" />\n    <end id=\"5\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"2\" to=\"4\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>";

    @Test
    public void testInternalNodeSignalEvent() {
        StringReader source = new StringReader(process);
        this.builder.addRuleFlow((Reader)source);
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        ArrayList<ProcessEvent> processEventList = new ArrayList<ProcessEvent>();
        ProcessEventListener listener = this.createProcessEventListener(processEventList);
        ((InternalWorkingMemory)session).getProcessRuntime().addEventListener(listener);
        ProcessInstance processInstance = ((InternalWorkingMemory)session).getProcessRuntime().startProcess("org.drools.core.event");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
        Assert.assertEquals((long)28L, (long)processEventList.size());
        for (ProcessEvent e : processEventList) {
            logger.debug(e.toString());
        }
        Assert.assertEquals((Object)"org.drools.core.event", (Object)((ProcessStartedEvent)processEventList.get(2)).getProcessInstance().getProcessId());
    }

    private ProcessEventListener createProcessEventListener(final List<ProcessEvent> processEventList) {
        return new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
    }
}

