/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.ReturnValueDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.jbpm.process.builder.dialect.mvel.MVELReturnValueEvaluatorBuilder;
import org.jbpm.process.instance.impl.MVELReturnValueEvaluator;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;

public class MVELReturnValueConstraintEvaluatorBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init(pkgBuilder, (InternalKnowledgePackage)pkg, null, dialectRegistry, (Dialect)mvelDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        MVELReturnValueEvaluatorBuilder builder = new MVELReturnValueEvaluatorBuilder();
        builder.build(context, node, descr, null);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkgBuilder.getPackages()));
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)ksession);
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkgBuilder.getPackage("pkg1").getDialectRuntimeRegistry().getDialectData("mvel");
        ((MVELReturnValueEvaluator)node.getReturnValueEvaluator()).compile(data);
        Assert.assertTrue((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
        ksession.setGlobal("value", (Object)false);
        Assert.assertFalse((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
    }
}

