/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.util.ArrayList;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ExecutionFlowControlTest
extends AbstractBaseTest {
    @Test
    public void testRuleFlowUpgrade() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        System.setProperty("drools.ruleflow.port", "true");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"ruleflow.drl", ExecutionFlowControlTest.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"ruleflow40.rfm", ExecutionFlowControlTest.class), ResourceType.DRF);
        KieBase kbase = kbuilder.newKieBase();
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ProcessInstance processInstance = ksession.startProcess("0");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assert.assertEquals((Object)"Rule4", list.get(3));
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        System.setProperty("drools.ruleflow.port", "false");
    }
}

