/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.drools.compiler.compiler.DroolsError;
import org.drools.core.common.InternalWorkingMemory;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStartTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessStartTest.class);

    @Test
    public void testStartConstraintTrigger() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.start\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"SomeVar\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n      <variable name=\"SomeOtherVar\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" >\n      <triggers>        <trigger type=\"constraint\" >\n          <constraint type=\"rule\" dialect=\"mvel\" >p:Person()</constraint>\n          <mapping type=\"in\" from=\"p.getName()\" to=\"SomeVar\" />\n          <mapping type=\"in\" from=\"&quot;SomeString&quot;\" to=\"SomeOtherVar\" />\n        </trigger>\n       </triggers>\n    </start>\n    <actionNode id=\"2\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >myList.add(context.getVariable(\"SomeVar\"));\nmyList.add(context.getVariable(\"SomeOtherVar\"));</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        if (!this.builder.getErrors().isEmpty()) {
            for (DroolsError error : this.builder.getErrors().getErrors()) {
                logger.error(error.toString());
            }
            Assert.fail((String)"Could not build process");
        }
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        Assert.assertEquals((long)0L, (long)myList.size());
        Person jack = new Person();
        jack.setName("Jack");
        session.insert((Object)jack);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)myList.size());
        Assert.assertEquals((Object)"Jack", myList.get(0));
        Assert.assertEquals((Object)"SomeString", myList.get(1));
    }

    @Test
    public void testStartEventTrigger() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.start\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"SomeVar\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n      <variable name=\"SomeOtherVar\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" >\n      <triggers>        <trigger type=\"event\" >\n          <eventFilters>            <eventFilter type=\"eventType\" eventType=\"myEvent\" />\n          </eventFilters>          <mapping type=\"in\" from=\"event\" to=\"SomeVar\" />\n          <mapping type=\"in\" from=\"SomeString\" to=\"SomeOtherVar\" />\n        </trigger>\n       </triggers>\n    </start>\n    <actionNode id=\"2\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >myList.add(context.getVariable(\"SomeVar\"));\nmyList.add(context.getVariable(\"SomeOtherVar\"));</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.addRuleFlow((Reader)source);
        if (!this.builder.getErrors().isEmpty()) {
            for (DroolsError error : this.builder.getErrors().getErrors()) {
                logger.error(error.toString());
            }
            Assert.fail((String)"Could not build process");
        }
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        ArrayList myList = new ArrayList();
        session.setGlobal("myList", myList);
        Assert.assertEquals((long)0L, (long)myList.size());
        ((InternalWorkingMemory)session).getProcessRuntime().signalEvent("myEvent", (Object)"Jack");
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)myList.size());
        Assert.assertEquals((Object)"Jack", myList.get(0));
        Assert.assertEquals((Object)"SomeString", myList.get(1));
    }
}

