/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jbpm.process.workitem.WorkItemRepository;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WorkItemRepositoryTest
extends AbstractBaseTest {
    private String repoName;

    @Parameterized.Parameters(name="Repository Name : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"repository"}, {"repositorynoindexconf"});
    }

    public WorkItemRepositoryTest(String repoName) {
        this.repoName = repoName;
    }

    @Test
    public void testGetWorkDefinitions() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource(this.repoName).toURI().toString());
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)9L);
    }

    @Test
    public void testGetWorkDefinitionsForNames() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource(this.repoName).toURI().toString(), (String[])new String[]{"TestServiceOne", "TestServiceTwo"});
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)2L);
    }

    @Test
    public void testGetWorkDefinitionsForInvalidNames() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource(this.repoName).toURI().toString(), (String[])new String[]{"TestServiceOne", "INVALID_NAME"});
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)1L);
        Map repoResults2 = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource(this.repoName).toURI().toString(), (String[])new String[]{"INVALID_NAME1", "INVALID_NAME2"});
        Assert.assertNotNull((Object)repoResults2);
        Assert.assertTrue((boolean)repoResults2.isEmpty());
        Map repoResults3 = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource(this.repoName).toURI().toString(), (String[])new String[0]);
        Assert.assertNotNull((Object)repoResults3);
        Assert.assertTrue((boolean)repoResults3.isEmpty());
    }
}

