/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.core.common.InternalAgenda;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFlowControlTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessFlowControlTest.class);

    protected KieBase getRuleBase(KieBaseConfiguration config) throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
    }

    @Test
    public void testRuleFlowConstraintDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ConstraintDialects.rfm")));
        logger.error(this.builder.getErrors().toString());
        Assert.assertEquals((long)0L, (long)this.builder.getErrors().getErrors().length);
        KieSession session = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList<Integer> inList = new ArrayList<Integer>();
        ArrayList outList = new ArrayList();
        session.setGlobal("inList", inList);
        session.setGlobal("outList", outList);
        inList.add(1);
        inList.add(3);
        inList.add(6);
        inList.add(25);
        FactHandle handle = session.insert(inList);
        session.startProcess("ConstraintDialects");
        Assert.assertEquals((long)4L, (long)outList.size());
        Assert.assertEquals((Object)"MVELCodeConstraint was here", outList.get(0));
        Assert.assertEquals((Object)"JavaCodeConstraint was here", outList.get(1));
        Assert.assertEquals((Object)"MVELRuleConstraint was here", outList.get(2));
        Assert.assertEquals((Object)"JavaRuleConstraint was here", outList.get(3));
        outList.clear();
        inList.remove(new Integer(1));
        session.update(handle, inList);
        session.startProcess("ConstraintDialects");
        Assert.assertEquals((long)3L, (long)outList.size());
        Assert.assertEquals((Object)"JavaCodeConstraint was here", outList.get(0));
        Assert.assertEquals((Object)"MVELRuleConstraint was here", outList.get(1));
        Assert.assertEquals((Object)"JavaRuleConstraint was here", outList.get(2));
        outList.clear();
        inList.remove(new Integer(6));
        session.update(handle, inList);
        session.startProcess("ConstraintDialects");
        Assert.assertEquals((long)2L, (long)outList.size());
        Assert.assertEquals((Object)"JavaCodeConstraint was here", outList.get(0));
        Assert.assertEquals((Object)"JavaRuleConstraint was here", outList.get(1));
        outList.clear();
        inList.remove(new Integer(3));
        session.update(handle, inList);
        session.startProcess("ConstraintDialects");
        Assert.assertEquals((long)1L, (long)outList.size());
        Assert.assertEquals((Object)"JavaRuleConstraint was here", outList.get(0));
        outList.clear();
        inList.remove(new Integer(25));
        session.update(handle, inList);
        try {
            session.startProcess("ConstraintDialects");
            Assert.fail((String)"This should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRuleFlow() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        KieSession workingMemory = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ProcessInstance processInstance = workingMemory.startProcess("0");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assert.assertEquals((Object)"Rule4", list.get(3));
    }

    @Test
    public void testRuleFlowUpgrade() throws Exception {
        System.setProperty("drools.ruleflow.port", "true");
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow40.rfm")));
        KieSession workingMemory = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ProcessInstance processInstance = workingMemory.startProcess("0");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assert.assertEquals((Object)"Rule4", list.get(3));
        System.setProperty("drools.ruleflow.port", "false");
    }

    @Test
    public void testRuleFlowClear() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ruleflowClear.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ruleflowClear.rfm")));
        KieSession workingMemory = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        final ArrayList activations = new ArrayList();
        DefaultAgendaEventListener listener = new DefaultAgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                activations.add(event.getMatch());
            }
        };
        workingMemory.addEventListener((AgendaEventListener)listener);
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        workingMemory.fireAllRules();
        agenda.evaluateEagerList();
        Assert.assertEquals((long)4L, (long)agenda.sizeOfRuleFlowGroup("flowgroup-1"));
        Assert.assertEquals((long)0L, (long)agenda.getAgendaGroup("MAIN").size());
        Assert.assertEquals((long)0L, (long)activations.size());
        ((InternalAgenda)workingMemory.getAgenda()).clearAndCancelRuleFlowGroup("flowgroup-1");
        Assert.assertEquals((long)0L, (long)agenda.getAgendaGroup("MAIN").size());
        Assert.assertEquals((long)0L, (long)agenda.sizeOfRuleFlowGroup("flowgroup-1"));
        Assert.assertEquals((long)4L, (long)activations.size());
    }

    @Test
    public void testRuleFlowInPackage() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        KieSession workingMemory = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ProcessInstance processInstance = workingMemory.startProcess("0");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assert.assertEquals((Object)"Rule4", list.get(3));
    }

    @Test
    public void testLoadingRuleFlowInPackage1() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.getPackages();
    }

    @Test
    public void testLoadingRuleFlowInPackage2() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        this.builder.getPackages();
    }

    @Test
    public void testLoadingRuleFlowInPackage3() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("empty_ruleflow.rfm")));
        this.builder.getPackages();
    }

    @Test
    public void testRuleFlowActionDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ActionDialects.rfm")));
        KieSession session = this.createKieSession(true, (KiePackage[])this.builder.getPackages());
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.startProcess("ActionDialects");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"mvel was here", list.get(0));
        Assert.assertEquals((Object)"java was here", list.get(1));
    }

    @Test
    public void testLoadingRuleFlowNoPackageName() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("error_ruleflow.rfm")));
        Assert.assertEquals((long)3L, (long)this.builder.getErrors().getErrors().length);
    }
}

