/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.ReturnValueDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.java.JavaDialect;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;

public class JavaReturnValueConstraintEvaluatorBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value;");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        JavaDialect javaDialect = (JavaDialect)dialectRegistry.getDialect("java");
        ProcessBuildContext context = new ProcessBuildContext((DroolsAssemblerContext)pkgBuilder, (InternalKnowledgePackage)pkg, (Process)process, (BaseDescr)processDescr, dialectRegistry, (Dialect)javaDialect);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        JavaReturnValueEvaluatorBuilder builder = new JavaReturnValueEvaluatorBuilder();
        builder.build((PackageBuildContext)context, node, descr, null);
        ProcessDialectRegistry.getDialect((String)"java").addProcess(context);
        javaDialect.compileAll();
        Assert.assertEquals((long)0L, (long)javaDialect.getResults().size());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkgBuilder.getPackages()));
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)ksession);
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        Assert.assertTrue((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
        ksession.setGlobal("value", (Object)false);
        Assert.assertFalse((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
    }
}

